<?php 

// Work out the best text colour based on the background.
$textColour = determin_text_colour(get_sub_field('background_colour'));

// Get the title font.
$titleFont = get_sub_field('title_font') . " ";

// Get the title transform.
$titleStyle = get_sub_field('title_style') . " ";

$paragraphColor = "";
if (get_sub_field('background_colour') == "bg-white") {
    $paragraphColor = "text-black";
} else {
    $paragraphColor = $textColour;
}

$svgFill = "#f2f0f0";
if (in_array($background["colour"], array("bg-white", "bg-smoke"))) {
    $svgFill = "#000000";
}
?>

<div class="relative <?php echo $background["colour"]; ?> <?php echo get_sub_field('text_alignment'); ?> <?php echo $textColour; ?>" <?php echo $background["style"]; ?>>
    <div class="container z-20 mx-auto py-10 px-6">

        <?php render_title(get_sub_field('title'), get_sub_field('title_type'),  trim($titleFont . $titleStyle . " max-w-4xl")); ?>
        <?php render_content(get_sub_field('content'), 'mb-8', $paragraphColor . " text-sm md:text-base max-w-4xl") ; ?>

        <?php if (!empty(get_sub_field('form'))) : ?>
            <div class="max-w-4xl relative z-10">
                <?php echo do_shortcode(get_sub_field('form')); ?>
            </div>
        <?php endif; ?>

    </div>
</div>