<?php 

// Work out the best text colour based on the background.
$textColour = determin_text_colour(get_sub_field('background_colour'));

// Get the title font.
$titleFont = get_sub_field('title_font') . " ";

// Get the title transform.
$titleStyle = get_sub_field('title_style') . " ";

$paragraphColor = "";
if (get_sub_field('background_colour') == "bg-white") {
    $paragraphColor = "text-black";
} else {
    $paragraphColor = $textColour;
}
?>

<div class="relative <?php echo $background["colour"]; ?> <?php echo get_sub_field('text_alignment'); ?> <?php echo $textColour; ?>" <?php echo $background["style"]; ?>>
    <div class="container z-20 relative mx-auto py-10 md:py-20 px-6">

        <?php render_title(get_sub_field('title'), get_sub_field('title_type'),  trim($titleFont . $titleStyle . " mx-auto max-w-4xl text-center")); ?>
        <?php render_content(get_sub_field('content'), 'mb-8', $paragraphColor . " text-center text-sm md:text-base max-w-4xl mx-auto") ; ?>

        <?php if (!empty(get_sub_field('form'))) : ?>
            <div class="max-w-xl mx-auto">
                <?php echo do_shortcode(get_sub_field('form')); ?>
            </div>
        <?php endif; ?>

    </div>
</div>