<?php 

// Work out the best text colour based on the background.
$textColour = determin_text_colour(get_sub_field('background_colour'));

// Get the background for the block.
$background = determin_background();

// Get the title font.
$titleFont = get_sub_field('title_font') . " ";

// Get the title transform.
$titleStyle = get_sub_field('title_style') . " ";

// A list of rotation options.
$roateClasses = ["hover:rotate-1", "hover:rotate-2", "hover:rotate-3", "hover:-rotate-1", "hover:-rotate-2", "hover:-rotate-3"];
/*<?php echo $roateClasses[mt_rand(0, 5)]; ?>*/
?>

<div class="relative px-6 py-20 <?php echo $background["colour"]; ?> <?php echo get_sub_field('text_alignment'); ?> <?php echo $textColour; ?>" <?php echo $background["style"]; ?>>
    <div class="container mx-auto text-center">

        <div class="md:mb-20 max-w-3xl mx-auto">
            <?php render_title(get_sub_field('title'), get_sub_field('title_type'),  trim($titleFont . $titleStyle)); ?>
            <?php render_content(get_sub_field('content'), 'mt-6') ; ?>
        </div>

        <div class="flex items-center flex-wrap justify-center place-items-center max-w-5xl mx-auto">
            <?php if (!empty(get_sub_field('images'))) : ?>
                <?php foreach (get_sub_field('images') as $key => $value) : ?>
                    <div class="w-1/2 md:w-1/4 flex items-center justify-center p-6 ease-in-out duration-200">
                        <?php render_image($value, 'logo', true, 'select-none'); ?>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>

    </div>
</div>