<?php 

// Work out the best text colour based on the background.
$textColour = determin_text_colour(get_sub_field('background_colour'));

// Get the background for the block.
$background = determin_background();

// Get the title font.
$titleFont = get_sub_field('title_font') . " ";

// Get the title transform.
$titleStyle = get_sub_field('title_style') . " ";


// A list of rotation options.
$roateClasses = ["hover:rotate-1", "hover:rotate-2", "hover:rotate-3", "hover:-rotate-1", "hover:-rotate-2", "hover:-rotate-3"];

?>

<div class="relative <?php echo $background["colour"]; ?> <?php echo get_sub_field('text_alignment'); ?> <?php echo $textColour; ?>" <?php echo $background["style"]; ?>>
    
    <?php if (!empty(get_sub_field('title')) || get_sub_field('content')) : ?>
        <div class="container pt-20 px-6 mx-auto text-center">
            <div class="md:mb-20 max-w-4xl mx-auto">
                <?php render_title(get_sub_field('title'), get_sub_field('title_type'),  trim($titleFont . $titleStyle)); ?>
                <?php render_content(get_sub_field('content'), 'mt-6', '') ; ?>
            </div>
        </div>
    <?php endif; ?>

    <div class="grid grid-cols-3 md:grid-cols-4 lg:grid-cols-5 place-items-center">
        <?php if (!empty($images = get_sub_field('images'))) : shuffle($images); ?>
            <?php foreach ($images as $key => $value) : ?>
                <div class="relative overflow-hidden group">
                    <?php render_image($value, 'square-large', true, 'select-none scale-100 group-hover:scale-110 ease-in-out duration-500'); ?>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
</div>