<?php

// Work out the best text colour based on the background.
$textColour = determin_text_colour(get_sub_field('background_colour'));

// Get the text alignment.
$text_alignment = 'text-center';

// Get the title font.
$titleFont = get_sub_field('title_font');

// Get the title transform.
$titleStyle = get_sub_field('title_style');

// Determine the content alignment.
$content_alignment = "";

if ($text_alignment == "text-center") {
    $content_alignment = "items-center justify-center";
}

if ($text_alignment == "text-right") {
    $content_alignment = "items-end justify-end";
}

// Get the number of columns.
$columns = get_sub_field('columns');

// Set content max word count.
$max_word_count = '42';
if ($columns == 4) {
    $max_word_count = "22";
}

// Animation delay options.
$animation_delay_quick = ['animate-delay-0', 'animate-delay-[1200ms]', 'animate-delay-[1300ms]', 'animate-delay-[1400ms]', 'animate-delay-[1500ms]', 'animate-delay-[1600ms]', 'animate-delay-[1700ms]', 'animate-delay-[1800ms]', 'animate-delay-[1900ms]'];

?>

<div class="relative overflow-hidden py-10 md:py-20 px-6 <?php echo $background["colour"]; ?> <?php echo $text_alignment; ?> <?php echo $textColour; ?> group/block" <?php echo $background["style"]; ?>>
    <?php echo ($background["colour"] == "bg-image") ? '<div class="absolute top-0 left-0 w-full h-full z-10 bg-black/50"></div>' : ""; ?>

<div class="container mx-auto relative z-20 flex flex-col <?php echo $content_alignment; ?>">

        <?php if (!empty(get_sub_field('title')) || !empty(get_sub_field('content'))) : ?>
            <div class="max-w-xl mx-auto">
                <?php render_title(get_sub_field('section_title'), 'p', 'uppercase text-sm mb-4'); ?>
                <?php render_title(get_sub_field('section_title'), 'p', 'uppercase text-sm font-bold mb-4', "animate-fade-up"); ?>
                <?php render_title(get_sub_field('title'), get_sub_field('title_type'), implode(" ", ['mb-6', $titleFont, $titleStyle]), "animate-fade-up animate-delay-[200ms]"); ?>
                <?php render_content(get_sub_field('content'), null, null, 'animate-fade-up animate-delay-[500ms]'); ?>
            </div>
        <?php endif; ?>

    </div>

    <?php if (!empty($images = get_sub_field('images')) && is_array($images) && count($images) > 0) : ?>
        <div class="container mx-auto z-20 flex flex-col <?php echo $content_alignment; ?>">
            <div class="swiper swiper-<?php echo $position; ?> my-10 w-full overflow-visible animate" data-animate="animate-fade-up animate-delay-[1200ms]">
                <div class="swiper-wrapper">

                    <?php foreach ($images as $key => $value) : ?>
                        <div class="swiper-slide max-w-[410px] max-h-[410px]">
                            <div class="relative group flex flex-col w-full h-full aspect-square">
                                <div class="aspect-square rounded-md overflow-hidden">
                                    <?php if (!empty(get_field('page_link', $value['id']))) : ?>
                                        <a href="<?php echo get_field('page_link', $value['id'])['url']; ?>">
                                    <?php endif; ?>

                                    <?php render_image($value, 'large-square', true, 'w-full h-full object-cover mb-6 scale-100 group-hover:scale-110 select-none ease-in-out duration-500'); ?>
                                    
                                    <?php if (!empty(get_field('page_link', $value['id']))) : ?>
                                        </a>
                                    <?php endif; ?>

                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>

                </div>
            </div>
            <div class="absolute top-1/2 left-[5vw] translate-y-2/4 right-0 z-20 pointer-events-none w-[90vw]">
                <div class="mx-auto h-16 z-20 pointer-events-none">
                    <div class=" pointer-events-auto swiper-button-prev swiper-button-prev-<?php echo $position; ?> relative z-30"></div>
                    <div class=" pointer-events-auto swiper-button-next swiper-button-next-<?php echo $position; ?> relative z-30"></div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <div class="container mx-auto relative z-20 flex flex-col <?php echo $content_alignment; ?>">

        <?php if (!empty(get_sub_field('clone_buttons', 'option'))) : ?>
            <div class="max-w-xl mx-auto">
                <?php render_buttons([
                    "buttons" => get_sub_field('clone_buttons', 'option'),
                    "wrapClass" => "flex",
                    "animate" => "animate-fade-up animate-delay-[700ms]"
                ]); ?>
            </div>
        <?php endif; ?>

    </div>
</div>
<script>
    window.addEventListener('load', () => {
        const swiper = new Swiper('.swiper-<?php echo $position; ?>', {
            loop: false,
            draggable: false,
            slidesPerView: 'auto',
            spaceBetween: 20,
            grabCursor: false,
            createElements: true,
            initialSlide: 1,
            loopedSlides: 2,

            breakpoints: {
                // when window width is >=
                640: {
                    spaceBetween: 20
                },
                768: {
                    spaceBetween: 30
                },
                1024: {
                    spaceBetween: 40
                },
                1140: {
                    spaceBetween: 40
                }
            },

            // Navigation arrows
            navigation: {
                nextEl: '.swiper-button-next-<?php echo $position; ?>',
                prevEl: '.swiper-button-prev-<?php echo $position; ?>',
            },
        });
    });
</script>