<?php

// Work out the best text colour based on the background.
$textColour = determin_text_colour(get_sub_field('background_colour'));

// Get the background for the block.
$background = determin_background();

// Get the title font.
$titleFont = get_sub_field('title_font') . " ";

// Get the title transform.
$titleStyle = get_sub_field('title_style') . " ";

// Get the images.
$images = get_sub_field('images');

?>

<div class="relative <?php echo (!empty(get_sub_field('title')) || !empty(get_sub_field('content'))) ? "pt-20":""; ?> <?php echo $background["colour"]; ?> <?php echo get_sub_field('text_alignment'); ?> <?php echo $textColour; ?>" <?php echo $background["style"]; ?>>

    <?php if (!empty(get_sub_field('title')) || !empty(get_sub_field('content'))) : ?>
        <div class="container mx-auto px-6">
            <div class="md:mb-10 max-w-3xl">
                <?php render_title(get_sub_field('title'), get_sub_field('title_type'),  trim($titleFont . $titleStyle)); ?>
                <?php render_content(get_sub_field('content'), 'mt-6', ''); ?>
            </div>
        </div>
    <?php endif; ?>


    <?php if (!empty($images[0])) : ?>
        <div class="relative h-[70vh] max-w-[1800px] mx-auto overflow-hidden bg-fixed bg-top" style="background-image: url(<?php echo $images[0]['url']; ?>);">
        </div>
    <?php endif; ?>
</div>