<?php 

// Work out the best text colour based on the background.
$textColour = determin_text_colour(get_sub_field('background_colour'));

// Get the background for the block.
$background = determin_background();

?>

<div class="max-w-[1900px] mx-auto <?php echo $background["colour"]; ?> text-center md:min-h-[46rem] flex items-center justify-end" <?php echo $background["style"]; ?>>
    <div class="container py-10 md:py-20 flex items-center <?php echo (get_sub_field('content_side') == "left") ? "justify-start" : "justify-end"; ?>">
        <div 
        class="rounded-xl px-4 py-10 md:py-20 md:px-24
                <?php echo (get_sub_field('content_background') == "bg-transparent") ? "max-w-2xl" : "max-w-3xl"; ?>
                <?php echo get_sub_field('content_background'); ?> 
                <?php echo determin_text_colour(get_sub_field('content_background'), "panel"); ?>
        ">

            <?php if (!empty(get_sub_field('section_title'))) : ?>
                <div class="text-primary text-sm font-bold mb-8"><?php echo get_sub_field('section_title'); ?></div>
            <?php endif; ?>

            <?php render_title(get_sub_field('title'), get_sub_field('title_type'), 'italic font-display font-normal mb-8 ' . $textColour ); ?>

            <?php render_content(get_sub_field('content'),$textColour, "text-inherit"); ?>

            <?php if (!empty(get_sub_field('clone_buttons', 'option'))) {
                render_buttons([
                    "buttons" => get_sub_field('clone_buttons', 'option'),
                    "wrapClass" => "flex justify-center mt-8",
                    "size" => "large"
                ]);
            } ?>
        </div>
    </div>
</div>
