<?php 

// Work out the best text colour based on the background.
$textColour = determin_text_colour(get_sub_field('background_colour'));

// Get the title font type.
$titleFont = "font-display";
if (!empty(get_sub_field('title_font_type'))) {
    $titleFont = get_sub_field('title_font_type');
}

// Get the background for the block.
$background = determin_background();

// Get the text alignment.
$textAlignment = get_sub_field('text_alignment');

// Set border colour.
$borderColour = "border-white/20";
if (in_array($background["colour"], array('bg-white', 'bg-smoke'))) {
    $borderColour = "border-black/15";
}

?>

<div class="py-10 md:py-20 px-6 <?php echo $background["colour"]; ?> <?php echo $textAlignment; ?> <?php echo $textColour; ?>" <?php echo $background["style"]; ?>>
    <div class="container mx-auto">

        <?php if (!empty(get_sub_field('title')) || !empty(get_sub_field('content'))) : ?>
            <div class="max-w-4xl mb-10 md:mb-20 mx-auto text-center animate" data-animate="animate-fade-up animate-ease-in-out">
                <?php render_title(get_sub_field('title'), get_sub_field('title_type'),  trim($titleFont . $titleStyle)); ?>
                <?php render_content(get_sub_field('content'), 'mt-6', '') ; ?>
            </div>
        <?php endif; ?>

        <?php if (!empty($columns = get_sub_field('panels')) && is_array($columns) && count($columns) > 0) : ?>
            <div class="grid gap-10 grid-cols-1 lg:grid-cols-2  max-w-6xl mx-auto">
                <?php foreach ($columns as $key => $value) : 
                    $titleOrder = ($key % 2 == 0) ? "flex-col" : "flex-col-reverse";
                    $rounded = ($key % 2 == 0) ? " rounded-2xl rounded-tl-4xl" : " rounded-2xl rounded-br-4xl";
                    ?>

                    <div class="relative flex <?php echo (get_sub_field('title_layout') == true) ? $titleOrder : "flex-col"; ?>">
                        <div class="h-72 mb-6 overflow-hidden <?php echo $rounded; ?>">
                            <a href="<?php echo $value['link']['url']; ?>">
                                <?php render_image($value['background'], 'full', true, 'w-full h-full object-cover mb-6 scale-100 hover:scale-110 ease-inpout duration-500'); ?>
                            </a>
                        </div>

                        <div class="flex items-start mb-6">
                            <div class="w-4/12">
                                <?php render_title($value['title'], 'h3', 'text-2xl'); ?>
                            </div>
                            <div class="w-8/12">
                                <?php render_content($value['content'], 'text-sm'); ?>
                                <?php if (!empty($value['link'])) : ?>
                                    <a href="<?php echo $value['link']['url']; ?>" class="flex items-center text-inherit hover:text-inherit hover:opacity-70 underline hover:svg-move">
                                        <?php echo $value['link']['title']; ?>
                                        <svg xmlns="http://www.w3.org/2000/svg" class="ml-2 h-3 w-3" viewBox="0 0 320 512"><!--!Font Awesome Pro 6.5.1 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2024 Fonticons, Inc.--><path d="M299.3 244.7c6.2 6.2 6.2 16.4 0 22.6l-192 192c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L265.4 256 84.7 75.3c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l192 192z" fill="currentColor"/></svg>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>  

                <?php endforeach; ?>
            </div>
        <?php endif; ?>

        <?php render_buttons([
            "buttons" => get_sub_field('clone_buttons', 'option'),
            "wrapClass" => "flex justify-center mt-10",
        ]); ?>

    </div>
</div>