<?php

// Work out the best text colour based on the background.
$textColour = determin_text_colour(get_sub_field('background_colour'));

// Get the text alignment.
$text_alignment = get_sub_field('text_alignment');

// Get the title font.
$titleFont = get_sub_field('title_font');

// Get the title transform.
$titleStyle = get_sub_field('title_style');

// Determine the content alignment.
$content_alignment = "";

if ($text_alignment == "text-center") {
    $content_alignment = "items-center justify-center";
}

if ($text_alignment == "text-right") {
    $content_alignment = "items-end justify-end";
}

// Get the number of columns.
$columns = get_sub_field('columns');

// Set content max word count.
$max_word_count = '42';
if ($columns == 4) {
    $max_word_count = "22";
}

// Animation delay options.
$animation_delay_quick = ['animate-delay-0', 'animate-delay-[1200ms]', 'animate-delay-[1300ms]', 'animate-delay-[1400ms]', 'animate-delay-[1500ms]', 'animate-delay-[1600ms]', 'animate-delay-[1700ms]', 'animate-delay-[1800ms]', 'animate-delay-[1900ms]'];

?>

<div class="relative py-10 md:py-20 px-6 <?php echo $background["colour"]; ?> <?php echo $text_alignment; ?> <?php echo $textColour; ?>" <?php echo $background["style"]; ?>>
    <?php echo ($background["colour"] == "bg-image") ? '<div class="absolute top-0 left-0 w-full h-full z-10 bg-black/50"></div>' : ""; ?>

    <div class="container mx-auto relative z-20 flex flex-col <?php echo $content_alignment; ?>">

        <?php if (!empty(get_sub_field('title')) || !empty(get_sub_field('content'))) : ?>
            <div class="max-w-4xl">
                <?php render_title(get_sub_field('section_title'), 'p', 'uppercase text-sm font-bold mb-4', "animate-fade-up"); ?>
                <?php render_title(get_sub_field('title'), get_sub_field('title_type'), implode(" ", ['mb-6', $titleFont, $titleStyle]), "animate-fade-up animate-delay-[200ms]"); ?>
                <?php render_content(get_sub_field('content'), null, null, 'animate-fade-up animate-delay-[500ms]'); ?>
                <?php render_buttons([
                    "buttons" => get_sub_field('clone_buttons', 'option'),
                    "wrapClass" => "flex mt-6 " . $content_alignment,
                    "animate" => "animate-fade-up animate-delay-[700ms]"
                ]); ?>
            </div>
        <?php endif; ?>

        <?php if (!empty($panels = get_sub_field('panels')) && is_array($panels) && count($panels) > 0) : ?>
            <div class="md:mt-10 w-full grid gap-10 grid-cols-1 lg:grid-cols-<?php echo $columns; ?>">
                <?php foreach ($panels as $key => $value) : ?>

                <a href="<?php echo $value['link']['url']; ?>" class="relative aspect-3/5 no-underline flex items-center justify-center w-full h-full overflow-hidden group animate" data-animate="animate-fade-up <?php echo (isset($animation_delay_quick[$key + 1])) ? $animation_delay_quick[$key + 1] : $animation_delay_quick[count($animation_delay_quick) - 1]; ?>">
                    <?php render_image($value['background'], 'square-large', true, 'absolute aspect-3/5 select-none object-cover w-full h-full scale-100 grayscale group-hover:grayscale-0 group-hover:scale-110 ease-in-out duration-500'); ?>

                    <div class="relative z-20 text-center text-white uppercase font-display px-4 py-3 text-[4em]"><?php echo $value['link']['title']; ?></div>
                </a>

                <?php endforeach; ?>
            </div>
        <?php endif; ?>

    </div>
</div>
