<?php 

// Work out the best text colour based on the background.
$textColour = determin_text_colour(get_sub_field('background_colour'));

// Get the background for the block.
$background = determin_background();

// Get the text alignment.
$textAlignment = get_sub_field('text_alignment');

// Get the title font.
$titleFont = get_sub_field('title_font') . " ";

// Get the title transform.
$titleStyle = get_sub_field('title_style') . " ";

// Handle the textured overlay
$texturedOverlay = "bg-textured-logo-light opacity-[0.03]";
if (in_array($background["colour"], array('bg-white'))) {
    $texturedOverlay = "bg-textured-logo-light opacity-40";
}

if (in_array($background["colour"], array('bg-smoke'))) {
    $texturedOverlay = "bg-textured-logo-dark opacity-[0.03]";
}

?>

<div class="relative py-10 md:py-20 px-6 <?php echo $background["colour"]; ?> <?php echo $textAlignment; ?> <?php echo $textColour; ?>" <?php echo $background["style"]; ?>>
    <div class="relative z-20 container mx-auto flex flex-wrap">
        <?php if (!empty(get_sub_field('title')) || !empty(get_sub_field('content'))) : ?>
            <div class="w-full md:w-5/12 animate" data-animate="animate-fade-up animate-ease-in-out">
                <?php render_title(get_sub_field('title'), get_sub_field('title_type'),  trim($titleFont . $titleStyle)); ?>
                <?php render_content(get_sub_field('content'), 'mt-6', '') ; ?>
                <?php render_buttons([
                    "buttons" => get_sub_field('clone_buttons', 'option'),
                    "wrapClass" => "flex mt-5 md:mt-10 " . $buttonAlignment,
                ]); ?>
            </div>
        <?php endif; ?>

        <div class="w-full md:w-7/12 md:pl-28">
            <?php foreach (get_sub_field('panels') as $key => $value) : ?>
                <div class="flex items-start mb-6 animate" data-animate="animate-fade-up animate-delay-1000 animate-ease-in-out">
                    <div class="mt-2">
                        <?php render_title($key + 1, 'span', 'w-16 h-16 block mr-6 flex items-center justify-center text-2xl rounded-full border border-inherit border-solid select-none'); ?>
                    </div>
                    <?php render_content($value['content']); ?> 
                </div>
            <?php endforeach; ?>
        </div>
    </div>

</div>