<?php 

// Work out the best text colour based on the background.
$textColour = determin_text_colour(get_sub_field('background_colour'));

// Get the title font type.
$titleFont = "font-display";
if (!empty(get_sub_field('title_font_type'))) {
    $titleFont = get_sub_field('title_font_type');
}

// Get the background for the block.
$background = determin_background();

// Get the text alignment.
$textAlignment = get_sub_field('text_alignment');
$contentAreaAlingment = "mx-auto";
$contentAreaWidth = "max-w-4xl";
$buttonAlignment = "justify-center";

// Change value when aligned left.
if ($textAlignment == "text-left") {
    $contentAreaAlingment = "";
    $contentAreaWidth = "max-w-2xl";
    $buttonAlignment = "justify-start";
}
// Change value when aligned right.
if ($textAlignment == "text-right") {
    $contentAreaAlingment = "ml-auto";
    $contentAreaWidth = "max-w-2xl";
    $buttonAlignment = "justify-end";
}

?>

<div class="py-10 md:py-20 px-6 overflow-hidden <?php echo $background["colour"]; ?> <?php echo $textAlignment; ?> <?php echo $textColour; ?>" <?php echo $background["style"]; ?>>
    <div class="container mx-auto">

        <div class="<?php echo $contentAreaWidth; ?> <?php echo $contentAreaAlingment; ?> mb-20 animate" data-animate="animate-fade-up animate-ease-in-out">
            <?php render_title(get_sub_field('title'), get_sub_field('title_type'), 'text-3xl md:text-4xl mb-5 md:mb-10 ' . $titleFont); ?>
            <?php render_content(get_sub_field('content'), null, 'text-base md:text-lg') ; ?>
            <?php render_buttons([
                "buttons" => get_sub_field('clone_buttons', 'option'),
                "wrapClass" => "flex mt-5 md:mt-10 " . $buttonAlignment,
            ]); ?>
        </div>

        <?php if (!empty($columns = get_sub_field('panels')) && is_array($columns) && count($columns) > 0) : ?>
            <div class="carousel-<?php echo $position; ?> owl-carousel owl-theme max-w-sm md:max-w-lg xl:max-w-5xl -mx-5">
                <?php foreach ($columns as $key => $value) : ?>
                    <?php if (!empty($value['link'])) : ?>
                        <a href="<?php echo $value['link']['url']; ?>" class="flex text-inherit no-underline hover:no-underline w-full">
                    <?php endif; ?>
                            <div class="relative w-full flex flex-col justify-between ease-in-out duration-300 animate" data-animate="animate-fade-up animate-ease-in-out animate-delay-[<?php echo $key * 500; ?>ms]">
                                <?php if (!empty($value['image'])) : ?>
                                    <div class="w-full h-96 rounded-md overflow-hidden mb-6 ">
                                        <?php render_image($value['image'], 'full', true, 'w-full h-full object-cover object-center'); ?>
                                    </div>
                                <?php endif; ?>
                                <?php render_title($value['title'], 'h3', 'relative z-20 font-bold text-xl md:text-3xl mb-6 select-text'); ?>
                            </div>
                    <?php if (!empty($value['link'])) : ?>
                        </a>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>

    </div>
</div>

<script>
window.addEventListener('load', () => {
    var owl = jQuery('.carousel-<?php echo $position; ?>');
    owl.owlCarousel({
        loop: false,
        margin: 40,
        nav: false,
        dots: false,
        stagePadding: 20,
        autoplay: false,
        smartSpeed: 500,
        responsive: {
            0: {
                items: 1
            },
            1024: {
                items: 2
            }
        }
    });

    owl.on("mousewheel", ".owl-stage", function (e) {
        if (e.originalEvent.wheelDelta > 0) {
            owl.trigger("next.owl");
        } else {
            owl.trigger("prev.owl");
        }
        e.preventDefault();
    });
});
</script>