<?php 

// Work out the best text colour based on the background.
$textColour = determin_text_colour(get_sub_field('background_colour'));

// Get the title font type.
$titleFont = "font-display";
if (!empty(get_sub_field('title_font_type'))) {
    $titleFont = get_sub_field('title_font_type');
}

// Get the background for the block.
$background = determin_background();

// Get the text alignment.
$textAlignment = get_sub_field('text_alignment');

// Set border colour.
$borderColour = "border-white/20";
if (in_array($background["colour"], array('bg-white', 'bg-smoke'))) {
    $borderColour = "border-black/15";
}

?>

<div class="py-10 md:py-20 px-6 <?php echo $background["colour"]; ?> <?php echo $textAlignment; ?> <?php echo $textColour; ?>" <?php echo $background["style"]; ?>>
    <div class="container mx-auto">

        <?php if (!empty(get_sub_field('title')) || !empty(get_sub_field('content'))) : ?>
            <div class="max-w-4xl mb-10 md:mb-20 mx-auto text-center animate" data-animate="animate-fade-up animate-ease-in-out">
                <?php render_title(get_sub_field('title'), get_sub_field('title_type'),  trim($titleFont . $titleStyle)); ?>
                <?php render_content(get_sub_field('content'), 'mt-6', '') ; ?>
            </div>
        <?php endif; ?>

        <?php if (!empty($columns = get_sub_field('panels')) && is_array($columns) && count($columns) > 0) : ?>
            <div class="grid gap-10 grid-cols-1 md:grid-cols-2 lg:grid-cols-<?php echo get_sub_field('columns'); ?> max-w-6xl mx-auto">
                <?php foreach ($columns as $key => $value) : ?>
                    <div class="relative p-8 w-full border border-solid <?php echo $borderColour; ?> hover:bg-white/5 overflow-hidden flex flex-col justify-between ease-in-out duration-300 animate" data-animate="animate-fade-up animate-delay-[1000ms] animate-ease-in-out">
                        
                        <?php if (!empty($value['background'])) : ?>
                            <?php render_image($value['background'], 'full', true, 'w-full h-full object-cover object-center absolute top-0 left-0 z-10'); ?>
                        <?php endif; ?>

                        <div class="relative z-20">
                            <?php render_title($value['title'], 'h3', 'relative z-20 font-bold text-xl mb-6 select-text'); ?>
                            <?php render_content($value['content'], 'text-sm'); ?> 
                        </div>
                        
                        <?php 
                            if (!empty($value['link'])) {
                                render_buttons([
                                    "buttons" => array(
                                        array(
                                            "link" => array(
                                                "url" => $value['link']['url'],
                                                "title" => $value['link']['title']
                                            ),
                                            "style" => "text",
                                            "colour" => 'primary'
                                        )
                                    ),
                                    "wrapClass" => "z-20 mt-4"
                                ]);
                            }; 
                        ?>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>

        <?php render_buttons([
            "buttons" => get_sub_field('clone_buttons', 'option'),
            "wrapClass" => "flex justify-center mt-10",
        ]); ?>

    </div>
</div>