<?php 

// Work out the best text colour based on the background.
$textColour = determin_text_colour(get_sub_field('background_colour'));

// Get the title font.
$titleFont = get_sub_field('title_font') . " ";

// Get the title transform.
$titleStyle = get_sub_field('title_style') . " ";

// Get the text alignment.
$textAlignment = get_sub_field('text_alignment');

// Handle the textured overlay
$texturedOverlay = "bg-textured-logo-light opacity-[0.03]";
if (in_array($background["colour"], array('bg-white'))) {
    $texturedOverlay = "bg-textured-logo-light opacity-40";
}

if (in_array($background["colour"], array('bg-smoke'))) {
    $texturedOverlay = "bg-textured-logo-dark opacity-[0.03]";
}
?>

<div class="relative py-10 px-6 md:py-20 overlfow-hidden <?php echo $background["colour"]; ?> <?php echo $textAlignment; ?> <?php echo $textColour; ?>" <?php echo $background["style"]; ?>>
    <div class="max-w-3xl mx-auto px-6">
        <div class="relative z-20 animate" data-animate="animate-fade-up animate-ease-in-out">
    
            <?php render_title(get_sub_field('title'), get_sub_field('title_type'),  trim($titleFont . $titleStyle . " relative text-xl md:text-2xl")); ?>
    
        </div>
    </div>
</div>
