<?php 

// Work out the best text colour based on the background.
$textColour = determin_text_colour(get_sub_field('background_colour'));

// Get the title font.
$titleFont = get_sub_field('title_font') . " ";

// Get the title transform.
$titleStyle = get_sub_field('title_style') . " ";

// Get the text alignment.
$textAlignment = get_sub_field('text_alignment');
$contentAreaAlingment = "mx-auto";
$contentAreaWidth = "max-w-3xl";
$buttonAlignment = "justify-center";

// Change value when aligned left.
if ($textAlignment == "text-left") {
    $contentAreaAlingment = "";
    $contentAreaWidth = "max-w-2xl";
    $buttonAlignment = "justify-start";
}
// Change value when aligned right.
if ($textAlignment == "text-right") {
    $contentAreaAlingment = "ml-auto";
    $contentAreaWidth = "max-w-2xl";
    $buttonAlignment = "justify-end";
}

?>

<div class="py-10 px-6 md:py-20 <?php echo $background["colour"]; ?> <?php echo $textAlignment; ?> <?php echo $textColour; ?>" <?php echo $background["style"]; ?>>
    <div class="container mx-auto px-6">
        <div class="<?php echo $contentAreaWidth; ?> <?php echo $contentAreaAlingment; ?> animate" data-animate="animate-fade-up animate-ease-in-out">
            <?php render_title(get_sub_field('title'), get_sub_field('title_type'),  trim($titleFont . $titleStyle)); ?>
            <?php render_content(get_sub_field('content'), 'mt-6', '') ; ?>
            <?php render_buttons([
                "buttons" => get_sub_field('clone_buttons', 'option'),
                "wrapClass" => "flex mt-5 md:mt-10 " . $buttonAlignment,
            ]); ?>
        </div>
        <?php if (!empty(get_sub_field('stats'))) : ?>
            <div class="flex items-center justify-center flex-wrap mt-10">
                <?php foreach (get_sub_field('stats') as $key => $value) : ?>
                    <div class="flex-1 flex flex-col text-center">
                        <div class="font-display text-6xl flex justify-center leading-none">
                            <?php if (!empty($value['statistic_prefix'])) : ?>
                                <span><?php echo $value['statistic_prefix']; ?></span>
                            <?php endif; ?>
                            <?php if (!empty($value['statistic_number'])) : ?>
                                <span data-from="0" data-to="<?php echo $value['statistic_number']; ?>"><?php echo $value['statistic_number']; ?></span>
                            <?php endif; ?>
                            <?php if (!empty($value['statistic_postfix'])) : ?>
                                <span><?php echo $value['statistic_postfix']; ?></span>
                            <?php endif; ?>
                        </div>
                        <?php render_title($value['statistic_label'], 'p'); ?>
                    </div>                
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php if (!empty(get_sub_field('stats'))) : ?>
<script>
    document.addEventListener('DOMContentLoaded', () => {
        inView('[data-to]')
            .on('enter', el => {
                console.log(el);
                if (!el.classList.contains('complete')) {
                    $(el).countTo({
                        speed: 2000,
                        refreshInterval: 5,
                        formatter: function (value, options) {
                            return value.toFixed(options.decimals);
                        },
                        onComplete: function (value) {
                            console.log(this[0].classList.add('complete'));
                        }
                    });
                }
            });
    });
</script>
<?php endif; ?>
