<?php 

// Work out the best text colour based on the background.
$textColour = determin_text_colour(get_sub_field('background_colour'));

// Get the title font.
$titleFont = get_sub_field('title_font') . " ";

// Get the title transform.
$titleStyle = get_sub_field('title_style') . " ";

// Get the background for the block.
$background = determin_background();

// Set the icon background colour.
$iconBackground = "bg-secondary fill-white text-white";
if (in_array($background['colour'], array('bg-black', 'bg-secondary'))) {
    $iconBackground = "bg-primary fill-white text-white";
}

// Set the SVG accsent colour.
$svgFill = "#f2f0f0";
if (in_array($background["colour"], array("bg-white", "bg-smoke"))) {
    $svgFill = "#000000";
}

?>

<div class="relative py-10 md:py-20 <?php echo $background["colour"]; ?> <?php echo get_sub_field('text_alignment'); ?> <?php echo $textColour; ?> <?php echo ($background["colour"] == "bg-white") ? "swap-bg":""; ?>" <?php echo $background["style"]; ?>>
    <div class="container z-20 mx-auto px-6 text-center">

        <div class="animate" data-animate="animate-fade-up animate-ease-in-out">
            <?php render_title(get_sub_field('title'), get_sub_field('title_type'),  trim($titleFont . $titleStyle)); ?>
            <?php render_content(get_sub_field('content'), 'mt-6', 'max-w-4xl mx-auto') ; ?>
        </div>

        <?php if (!empty(get_sub_field('testimonials'))) : ?>
            <div class="relative mt-10 px-10 h-full">
                <div class="swiper swiper-<?php echo $position; ?>">
                    <div class="swiper-wrapper pt-16">
                        <?php foreach (get_sub_field('testimonials') as $key => $testimonial) : ?>
                            <div class="swiper-slide">
                                <div class="bg-white text-black p-10 pt-20 h-full flex flex-col justify-between">
                                    <div class="<?php echo $iconBackground; ?> rounded-full h-24 w-24 flex items-center justify-center absolute left-1/2 top-0 -translate-x-2/4 -translate-y-2/4 overflow-hidden">
                                        <?php 
                                            if (!empty(get_post_thumbnail_id($testimonial))) {
                                                render_image(array("ID" => get_post_thumbnail_id($testimonial)), 'full', true, 'object-cover object-center w-full h-full');
                                            } else {
                                                switch(get_field('customer_icon', $testimonial)) {
                                                    case "clipboard":
                                                        echo '<svg class="h-14" xmlns="https://www.w3.org/2000/svg" xmlns:xlink="https://www.w3.org/1999/xlink" width="42.599" height="58.615" viewBox="0 0 42.599 58.615"><g><path d="M40.936,30.16c-.281,6.269-.125,12.549-.2,18.822-.039,3.436.72,7.616-3.719,7.865-2.063.116-4.15.219-6.218.226-4.56.015-9.092.077-13.65.178-2.56.057-5.122.043-7.682-.007a21.286,21.286,0,0,1-4.3-.113c-3.857-.946-3.609-4.119-3.659-7.219q-.059-3.646-.107-7.294c-.068-5.434-.106-10.869-.072-16.3.019-3,.059-6,.144-9,.045-1.584-.444-4.608.2-6.07,1.05-2.377,7.454-1.912,10.835-1.795a4.073,4.073,0,0,0-.816,1.778.626.626,0,0,0-.078.315c0,.24-.006.524-.017.822-1.732-.109-4.689-.459-5.9.24-1.266.728-.816,2.374-.776,3.652.131,4.162-.113,8.328-.073,12.492.2,6.621-.138,13.245.339,19.862.112,1.551-.038,3.979,1.268,5.044.636.519,2.827.526,3.738.6a37.1,37.1,0,0,0,5.235.015c3.5-.2,7.011-.342,10.509-.275,2.845.054,5.652-.132,8.5-.247,1.014-.04,2.1-.017,2.62-1,.64-1.209.144-4,.155-5.3.068-7.831.031-15.664-.012-23.495-.017-3.064.087-6.163-.078-9.223-.161-2.981-4-2.408-6.47-2.366-.039-.239-.086-.489-.142-.756a3.961,3.961,0,0,0-1.073-2.007c1.149.02,2.3.033,3.446.045q1.8.019,3.59.042c2.346.031,3.438-.273,4.173,2.122,1.7,5.546.542,12.648.286,18.342M30.781,13.72c1.227.045,2.465.166,3.682.152.427-.005,1.394.146,1.322.039.183.274.025,1.311.03,1.627.033,2.417.045,4.835.06,7.252q.062,10.357.041,20.713c-.008,2.426,0,4.855-.067,7.281-.006.236.117,1.427-.061,1.6-.605.584-4,.031-4.93.109a77.477,77.477,0,0,1-8.388.378c-3.145-.083-6.2.145-9.363.166-1.948.013-5.448.517-6.257-1.374-.484-1.131-.335-2.931-.4-4.149C6.088,41.258,6.367,35,6.175,28.75c-.027-2.833.075-5.652.1-8.483.012-1.141-.7-5.072-.086-6.045.535-.843,3.81-.624,5.393-.535.026,1.168.238,2.333,1.192,2.8,1.711.836,5.07.111,6.873.094,2.3-.022,4.6.031,6.9-.048,2.928-.1,4.242-.582,4.23-2.812M18.028,7.335a.67.67,0,0,0,.3-.746c-.4-1.912-1.06-4.012,1.359-4.949,1.452-.563,3.974-.4,4.633,1.34.4,1.052-.252,2.523-.707,3.451a.676.676,0,0,0,.1.8c1.5,1.255,3.763,1.954,4.929,3.521a2.912,2.912,0,0,1,.654,2.384c-.6,2.483-3.241,2.109-5.28,2.131-2.515.027-5.033.087-7.548.084a7.8,7.8,0,0,1-2.348-.064c-1.393-.557-.976-.682-1.164-1.828a13.606,13.606,0,0,1-.018-1.915c.271-2.164,3.326-3.377,5.083-4.209M42.091,36c.053-8.174,1.218-16.409-.168-24.537-.556-3.263-1.692-3.04-4.884-3.085-3.112-.044-6.229-.026-9.34-.133a.591.591,0,0,0-.077.013c-.478-.289-.977-.576-1.472-.9-1.607-1.052-.745-1.139-.512-2.847A4.1,4.1,0,0,0,25.084,1.5C23.64-.474,19.79-.351,17.99,1c-2.07,1.556-.637,3.176-1.12,5.051-.215.835-1.989,1.369-3,2.116a.629.629,0,0,0-.11-.02c-3.46.07-8.341-.687-11.624.647C.658,9.4.411,10.3.285,11.8.063,14.405.157,17.108.1,19.725-.044,26.715-.011,33.709.066,40.7q.044,4.025.111,8.05c.033,2.077-.367,4.772.571,6.7C2.6,59.27,7.329,58.54,10.817,58.588c6.156.084,12.3-.256,18.455-.2,2.442.021,4.868-.239,7.3-.223,2.011.013,3.463.191,4.655-1.686,1.5-2.369.817-6.036.843-8.687.038-3.928-.008-7.856.018-11.784" transform="translate(0 0)" fill="current"/><path d="M51.66,64.3a35.8,35.8,0,0,0-6.029-.067c-.837.086-.846,1.408,0,1.321a34.175,34.175,0,0,1,6.029.067,15.354,15.354,0,0,0,2.83-.174,26.143,26.143,0,0,1,4.229.072c.85.036.848-1.285,0-1.321-1.032-.044-2.053-.236-3.086-.2-1.339.044-2.62.384-3.973.3" transform="translate(-29.194 -41.518)" fill="current"/><path d="M44.974,84.759c-.848.028-.852,1.349,0,1.321,2.355-.078,4.7-.1,7.055.021a52.049,52.049,0,0,0,6.486-.147c.844-.055.85-1.377,0-1.321-4.506.3-9-.026-13.542.125" transform="translate(-28.763 -54.905)" fill="current"/><path d="M58.372,105.1c-2.372.1-4.74.159-7.114.124-2.4-.035-4.588-.3-6.911.313a.661.661,0,0,0,.351,1.274c2.43-.641,4.912-.276,7.409-.256,2.091.017,4.177-.045,6.266-.134.847-.036.851-1.358,0-1.321" transform="translate(-28.466 -68.186)" fill="current"/><path d="M58.612,125.336c-4.657.614-9.253-.846-13.841,0-.835.154-.481,1.428.351,1.274,4.433-.82,8.967.642,13.49.045.831-.11.841-1.432,0-1.321" transform="translate(-28.737 -81.137)" fill="current"/><path d="M35.567,65.143a7.718,7.718,0,0,0-1.209-.039c-.847.039-.851,1.36,0,1.321a7.716,7.716,0,0,1,1.209.039c.844.093.837-1.229,0-1.321" transform="translate(-21.877 -42.232)" fill="current"/><path d="M33.78,86.261c.021-.005.612-.039.494-.173l0-.017a.724.724,0,0,0,1.032-.107l.008-.011a.666.666,0,0,0-.1-.8c-.384-.438-1.294-.287-1.78-.167a.661.661,0,0,0,.351,1.274" transform="translate(-21.382 -55.054)" fill="current"/><path d="M35,106.665l-1.184-.011a.661.661,0,0,0,0,1.321l1.184.011a.661.661,0,0,0,0-1.321" transform="translate(-21.524 -69.193)" fill="current"/><path d="M34.975,125.944l-1.089.042c-.848.033-.852,1.354,0,1.321l1.089-.042c.847-.033.851-1.354,0-1.321" transform="translate(-21.57 -81.706)" fill="current"/><path d="M59,11.092h.026a.661.661,0,0,0,0-1.321H59a.661.661,0,0,0,0,1.321" transform="translate(-37.86 -6.339)" fill="current"/><path d="M41.876,30.686c.047-.576-.156-1.18.194-1.686a3.178,3.178,0,0,1,1.292-1.023c.767-.366.1-1.505-.667-1.14a4.408,4.408,0,0,0-1.78,1.515c-.5.744-.292,1.5-.36,2.334s1.252.843,1.321,0" transform="translate(-26.309 -17.364)" fill="current"/><path d="M51.09,25.608a.661.661,0,0,0,0-1.321.661.661,0,0,0,0,1.321" transform="translate(-32.731 -15.756)" fill="current"/></g></svg>';
                                                        break;
                                                    case "weights":
                                                        echo '<svg class="h-9" xmlns="https://www.w3.org/2000/svg" xmlns:xlink="https://www.w3.org/1999/xlink" width="79.756" height="44.822" viewBox="0 0 79.756 44.822"><g><path d="M75.829,25.084c-.073-1.695-.164-3.356-.184-4.89,0-.1,0-.2-.005-.3.418,0,.835,0,1.254.018.613.022.623-.108.806.369a5.75,5.75,0,0,1,.025,1.445c.029.517.1,1.03.14,1.546.033.416.053.835.049,1.254a3.158,3.158,0,0,0-.023.44.519.519,0,0,1-.185.049c-.629,0-1.251.054-1.877.068m-2.04,4.7a19.939,19.939,0,0,1-.223,4.037c-.78,3.043-2.682,2.879-5.379,2.922-.038-1.927-.206-3.893-.18-5.677.051-3.372.064-6.732,0-10.1-.084-4.232.225-8.5.1-12.738a15.064,15.064,0,0,1,3.361.291c2.021.554,2.059.753,2.267,3.043.258,2.83.065,5.795.1,8.637.041,3.2.066,6.4-.045,9.589M66.27,12.719c-.069,2.749-.131,5.49-.077,8.241.077,3.9.023,7.788-.022,11.687-.05,4.3,1.262,9.864-4.834,9.957-1.017.015-2.9.39-3.868-.038-2.727-1.211-2.234-3.32-2.278-5.543-.076-3.841-.079-7.682-.03-11.523.051-3.995.152-7.989.277-11.982C55.574,9.205,54.28,1.767,60.5,1.812c3.693.028,5.111,1.239,5.719,5.119a32.981,32.981,0,0,1,.054,5.788M26.551,24.925q-.017-2.366-.047-4.738c4.1-.159,8.215-.185,12.311-.233,4.771-.057,9.85.494,14.6.105q-.029,2.369-.055,4.729c-8.9.475-17.892.029-26.807.136M24.673,39.017c-.131,1.967.074,3.372-2,3.85a19.552,19.552,0,0,1-4.043,0c-2.2-.031-4.293-1-4.919-3.3-.452-1.662.059-4.154.042-5.894-.04-4.161-.112-8.312-.03-12.473.054-2.751-.032-5.492-.078-8.241-.036-2.176.147-4.341.127-6.516-.035-3.576,2.368-4.4,5.647-4.391A5.686,5.686,0,0,1,23.962,4.3c.524.826.268,2.841.32,3.867.107,2.126.15,4.257.212,6.385.121,4.076.214,8.153.256,12.23.042,4.059.191,8.182-.078,12.235M6.354,33.892a24.677,24.677,0,0,1-.277-4.422c-.2-3.835-.3-7.675-.27-11.515.017-2.254-.237-4.95.295-7.154.623-2.581,3.129-2.288,5.562-2.341-.077,4.229.324,8.561.242,12.734-.1,5.14-.382,10.56-.172,15.782-2.849-.047-4.593.12-5.381-3.084M1.922,24.8c-.089-.81,0-1.72-.005-2.5-.006-.486-.018-.973-.016-1.459,0-.125.112-.731-.047-.787a6.892,6.892,0,0,1,1.223-.025c.293-.008.587,0,.881.008-.04,1.573-.1,3.219-.125,4.88A8.222,8.222,0,0,1,1.922,24.8m77.763-1.43c-.05-.7-.146-1.384-.165-2.082a3.738,3.738,0,0,0-.358-2.306c-.82-1.089-2.307-.94-3.553-.913-.036-1.825-.075-3.65-.076-5.475,0-1.256.421-3.407-.346-4.527C73.929,6.235,70.233,6.465,68.021,6.4,68,6.1,68,5.786,67.978,5.478,67.569.771,65.011.035,60.5,0c-4.986-.037-6.282,1.723-6.629,6.614-.273,3.858-.37,7.747-.427,11.632-4.757.393-9.847-.16-14.626-.1-4.1.048-8.231.074-12.333.234-.059-3.851-.168-7.7-.436-11.528C25.7,2,24.413.2,19.415.234c-3.484,0-7.061.334-7.512,4.3-.079.7-.135,1.4-.174,2.106C9.552,6.687,6.15,6.5,4.884,8.1c-1.615,2.044-.87,7.467-.888,9.853,0,.082,0,.17,0,.253a7.41,7.41,0,0,0-2.974.221C-.449,19.051.1,21.545.11,22.793c.015,1.294-.45,3.359,1.169,3.7a10.682,10.682,0,0,0,2.535.178,36.578,36.578,0,0,0,.852,8.731c.843,3.336,4.046,3.322,7.163,3.384.028.43.03.871.066,1.3.37,4.222,2.682,4.5,6.418,4.564,2.378.04,6.123.873,7.51-1.516.819-1.411.646-3.864.7-5.435.109-3.38.08-6.769.051-10.15,0-.269,0-.541-.006-.81,8.906-.106,17.891.338,26.777-.136-.032,3.023-.042,6.047.012,9.07.035,1.956-.291,4.441.341,6.307,1.077,3.188,4.829,2.481,7.644,2.438,3.18-.048,5.822.159,6.569-3.51a15.288,15.288,0,0,0,.269-2.354c2.962-.057,6.208-.066,7.055-3.261a30.22,30.22,0,0,0,.663-8.33,6.208,6.208,0,0,0,2.961-.4c1.132-.573.909-2.116.831-3.189" transform="translate(0 0)" fill="current"/><path d="M31.8,12.686c-.864,2.067-.594,4.677-.329,6.843.14,1.143,1.954,1.157,1.812,0-.246-2.014-.538-4.442.264-6.361.449-1.075-1.3-1.544-1.747-.482" transform="translate(-16.173 -6.264)" fill="current"/><path d="M36.683,7.759a.907.907,0,0,0,0,1.812.907.907,0,0,0,0-1.812" transform="translate(-18.556 -4.021)" fill="current"/><path d="M118.58,11.189a6.726,6.726,0,0,0-.817,3.191,20.357,20.357,0,0,0-.111,3.91c.1,1.153,1.911,1.164,1.812,0a19.55,19.55,0,0,1,.049-3.252,6.1,6.1,0,0,1,.632-2.935c.694-.938-.877-1.842-1.565-.914" transform="translate(-60.943 -5.597)" fill="current"/><path d="M124.041,6.8a.907.907,0,0,0,0,1.812.907.907,0,0,0,0-1.812" transform="translate(-63.827 -3.523)" fill="current"/></g></svg>';
                                                        break;
                                                    case "apple":
                                                        echo '<svg class="h-12" xmlns="https://www.w3.org/2000/svg" xmlns:xlink="https://www.w3.org/1999/xlink" width="49.35" height="53.988" viewBox="0 0 49.35 53.988"><g transform="translate(-5.25 -5.009)"><g transform="translate(7.25 8.009)"><path d="M35.752,44.954c-4.19,3.913-8.855-.248-13.544-.053-2.243.093-4.218,1.267-6.356,1.8-3.825.952-6.079-1.811-7.982-4.694-3.215-4.872-6.187-10.15-6.566-16.1S3.52,12.48,10.122,11.258c4.73-.875,8.351,2.285,12.847,2.625a.581.581,0,0,0,.271.024,13.742,13.742,0,0,0,3.807-.692,15.706,15.706,0,0,0,1.757-.577c2.664-.919,5.307-1.876,8.078-1.12,7.528,2.056,7.975,11.419,6.55,17.672-1.222,5.363-3.58,11.934-7.679,15.763M15.8,4.209a9.1,9.1,0,0,1,1.075-2.58A16.154,16.154,0,0,1,22.21,9.718,11.835,11.835,0,0,0,15.8,4.209M33.219,1.324A8.875,8.875,0,0,1,31.3,9.614c-1.875,1.913-4.759,2.559-7.363,2.935a.58.58,0,0,0,.022-.166A10.708,10.708,0,0,1,33.219,1.324m4.837,9.26a9.523,9.523,0,0,0-5.8-.193c.112-.119.236-.221.341-.349A10.236,10.236,0,0,0,34.35.661a.65.65,0,0,0-.08-.14A.527.527,0,0,0,33.675,0,12.214,12.214,0,0,0,23.17,8.42,17.912,17.912,0,0,0,17.06.187a.491.491,0,0,0-.53-.065.527.527,0,0,0-.053.029.558.558,0,0,0-.1.078A.58.58,0,0,0,16.3.285,10.317,10.317,0,0,0,14.43,4.424a.566.566,0,0,0,.131.553.593.593,0,0,0,.309.222,10.534,10.534,0,0,1,7.085,7.3c-3.889-.648-7.2-3.1-11.41-2.581a11.546,11.546,0,0,0-8.905,6.95c-4.349,9.4.666,20.677,6.8,28.076,3.213,3.875,6.2,3.453,10.6,1.993,3.189-1.059,5.353-.448,8.455.331a14.069,14.069,0,0,0,5.434.6C37.2,47.2,39.956,42,41.494,38.454c2.264-5.225,4.012-10.591,3.845-16.35-.139-4.774-2.6-9.74-7.283-11.52" transform="translate(0 0)" fill="current" stroke="currentColor" stroke-width="1"/><path d="M22.857,44.536c-4.253,1.751-6.4,7.112-5.687,11.435.132.8,1.347.46,1.215-.335-.591-3.565,1.243-8.418,4.807-9.886.74-.3.416-1.524-.335-1.215" transform="translate(-11.328 -29.584)" fill="current"/><path d="M18.73,86.544a.63.63,0,0,0,0,1.26.63.63,0,0,0,0-1.26" transform="translate(-12.051 -57.552)" fill="current"/></g></g></svg>';
                                                        break;
                                                    default:
                                                        echo '<svg class="h-12" xmlns="https://www.w3.org/2000/svg" xmlns:xlink="https://www.w3.org/1999/xlink" width="49.35" height="53.988" viewBox="0 0 49.35 53.988"><g transform="translate(-5.25 -5.009)"><g transform="translate(7.25 8.009)"><path d="M35.752,44.954c-4.19,3.913-8.855-.248-13.544-.053-2.243.093-4.218,1.267-6.356,1.8-3.825.952-6.079-1.811-7.982-4.694-3.215-4.872-6.187-10.15-6.566-16.1S3.52,12.48,10.122,11.258c4.73-.875,8.351,2.285,12.847,2.625a.581.581,0,0,0,.271.024,13.742,13.742,0,0,0,3.807-.692,15.706,15.706,0,0,0,1.757-.577c2.664-.919,5.307-1.876,8.078-1.12,7.528,2.056,7.975,11.419,6.55,17.672-1.222,5.363-3.58,11.934-7.679,15.763M15.8,4.209a9.1,9.1,0,0,1,1.075-2.58A16.154,16.154,0,0,1,22.21,9.718,11.835,11.835,0,0,0,15.8,4.209M33.219,1.324A8.875,8.875,0,0,1,31.3,9.614c-1.875,1.913-4.759,2.559-7.363,2.935a.58.58,0,0,0,.022-.166A10.708,10.708,0,0,1,33.219,1.324m4.837,9.26a9.523,9.523,0,0,0-5.8-.193c.112-.119.236-.221.341-.349A10.236,10.236,0,0,0,34.35.661a.65.65,0,0,0-.08-.14A.527.527,0,0,0,33.675,0,12.214,12.214,0,0,0,23.17,8.42,17.912,17.912,0,0,0,17.06.187a.491.491,0,0,0-.53-.065.527.527,0,0,0-.053.029.558.558,0,0,0-.1.078A.58.58,0,0,0,16.3.285,10.317,10.317,0,0,0,14.43,4.424a.566.566,0,0,0,.131.553.593.593,0,0,0,.309.222,10.534,10.534,0,0,1,7.085,7.3c-3.889-.648-7.2-3.1-11.41-2.581a11.546,11.546,0,0,0-8.905,6.95c-4.349,9.4.666,20.677,6.8,28.076,3.213,3.875,6.2,3.453,10.6,1.993,3.189-1.059,5.353-.448,8.455.331a14.069,14.069,0,0,0,5.434.6C37.2,47.2,39.956,42,41.494,38.454c2.264-5.225,4.012-10.591,3.845-16.35-.139-4.774-2.6-9.74-7.283-11.52" transform="translate(0 0)" fill="current" stroke="currentColor" stroke-width="1"/><path d="M22.857,44.536c-4.253,1.751-6.4,7.112-5.687,11.435.132.8,1.347.46,1.215-.335-.591-3.565,1.243-8.418,4.807-9.886.74-.3.416-1.524-.335-1.215" transform="translate(-11.328 -29.584)" fill="current"/><path d="M18.73,86.544a.63.63,0,0,0,0,1.26.63.63,0,0,0,0-1.26" transform="translate(-12.051 -57.552)" fill="current"/></g></g></svg>';
                                                        break;
                                                } 
                                            }
                                        ?>
                                    </div>
                                    <?php render_content($testimonial->post_content, null, 'text-sm text-inherit'); ?>
                                    <div class="mt-4">
                                        <?php render_title(get_field('customer_name', $testimonial), 'div', 'font-bold uppercase'); ?>
                                        <?php render_title(get_field('customer_product_or_service', $testimonial), 'div', 'text-xs text-primary uppercase'); ?>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>

                <div class="swiper-pagination swiper-pagination-<?php echo $position; ?>"></div>
                <div class="swiper-button-prev swiper-button-prev-<?php echo $position; ?> relative z-30"></div>
                <div class="swiper-button-next swiper-button-next-<?php echo $position; ?> relative z-30"></div>

            </div>
        <?php endif; ?>

    </div>
</div>

<script>
    window.addEventListener('load', () => {
        const swiper = new Swiper('.swiper-<?php echo $position; ?>', {
            loop: true,
            draggable: true,
            slidesPerView: 1,
            spaceBetween: 20,
            grabCursor: true,
            createElements: true,

            breakpoints: {
                // when window width is >=
                640: {
                    slidesPerView: 2,
                    spaceBetween: 20
                },
                768: {
                    slidesPerView: 2,
                    spaceBetween: 30
                },
                1024: {
                    slidesPerView: 2,
                    spaceBetween: 40
                },
                1140: {
                    slidesPerView: 3,
                    spaceBetween: 40
                }
            },

            // If we need pagination
            pagination: {
                el: '.swiper-pagination-<?php echo $position; ?>',
                clickable: true,
            },

            // Navigation arrows
            navigation: {
                nextEl: '.swiper-button-next-<?php echo $position; ?>',
                prevEl: '.swiper-button-prev-<?php echo $position; ?>',
            },
        });
    });

</script>