<?php 

// Work out the best text colour based on the background.
$textColour = determin_text_colour(get_sub_field('background_colour'));

// Get the title font.
$titleFont = get_sub_field('title_font') . " ";

// Get the title transform.
$titleStyle = get_sub_field('title_style') . " ";

// Get the background for the block.
$background = determin_background();

// Rotation Options
$rotateOptions = array('hover:rotate-1', 'hover:rotate-2', 'hover:rotate-3', 'hover:-rotate-1', 'hover:-rotate-2', 'hover:-rotate-3');

?>

<div class="relative py-10 md:py-20 <?php echo $background["colour"]; ?> <?php echo get_sub_field('text_alignment'); ?> <?php echo $textColour; ?> <?php echo ($background["colour"] == "bg-white") ? "swap-bg":""; ?>" <?php echo $background["style"]; ?>>
    <div class="container z-20 relative mx-auto px-6 text-center">

        <div class="animate" data-animate="animate-fade-up animate-ease-in-out">
            <?php render_title(get_sub_field('title'), get_sub_field('title_type'),  trim($titleFont . $titleStyle)); ?>
            <?php render_content(get_sub_field('content'), 'mt-6', 'max-w-4xl mx-auto') ; ?>
        </div>

        <?php if (!empty(get_sub_field('testimonials'))) : ?>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 max-w-4xl mx-auto mt-10 animate"  data-animate="animate-fade-up animate-delay-500 animate-ease-in-out">
                <?php foreach (get_sub_field('testimonials') as $key => $testimonial) : ?>
                    <div class="border-2 border-transparent border-solid bg-white text-black box-shadow-sm h-full p-10 text-center flex flex-col justify-between hover:border-primary <?php echo $rotateOptions[rand(0,5)]; ?> ease-in-out duration-100">
                        <?php render_content($testimonial->post_content, null, 'text-sm text-inherit'); ?>
                        <div class="mt-4">
                            <?php render_title(get_field('customer_name', $testimonial), 'div', 'font-bold uppercase'); ?>
                            <?php render_title(get_field('customer_product_or_service', $testimonial), 'div', 'text-xs text-primary uppercase'); ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>

    </div>
</div>
