<?php

// Work out the best text colour based on the background.
$textColour = determin_text_colour(get_sub_field('background_colour'));

// Get the title font.
$titleFont = get_sub_field('title_font');

// Get the title transform.
$titleStyle = get_sub_field('title_style');

// Get the text alignment.
$text_alignment = get_sub_field('text_alignment');
$content_alignment = "";

if ($text_alignment == "text-center") {
    $content_alignment = "items-center justify-center";
}

if ($text_alignment == "text-right") {
    $content_alignment = "items-end justify-end";
}

// Determine the video type.
$videoType = "";
$videoURL = get_sub_field('video');

if (strpos($videoURL, 'youtu') !== false) {
    $videoType = "youtube";

    // Get the video id. 
    if (preg_match('/youtu\.be\/([^\?\/]+)/', $videoURL, $matches)) {
        $videoId = $matches[1];
    } elseif (preg_match('/[\\?\\&]v=([^\\?\\&]+)/', $videoURL, $matches)) {
        $videoId = $matches[1];
    }

    $iframe = "<span class='text-center'>Video URL format not supported.</span>";
    if (!empty($videoURL)) {
        // Create the YouTube Video Embed Script
        $iframe = <<<EOD
            <iframe id="youtube-player" class="w-full h-auto aspect-video border-0" width="560" height="315" src="https://www.youtube.com/embed/{$videoId}?enablejsapi=1&rel=0" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
            <script>
                var tag = document.createElement('script');
                tag.src = "https://www.youtube.com/iframe_api";
                var firstScriptTag = document.getElementsByTagName('script')[0];
                firstScriptTag.parentNode.insertBefore(tag, firstScriptTag);

                var player;
                function onYouTubeIframeAPIReady() {
                    player = new YT.Player('youtube-player', {
                        events: {
                            'onStateChange': onPlayerStateChange
                        }
                    });
                }

                function onPlayerStateChange(event) {
                    if (event.data == YT.PlayerState.ENDED) {
                        player.seekTo(0);
                        player.stopVideo();
                    }
                }
            </script>
            EOD;
    }
} else {
    $videoType = "cdn";

    // Get the video file type. 
    $videoExt = pathinfo(get_sub_field('video'), PATHINFO_EXTENSION);
}
?>

<div class="relative py-10 px-6 md:py-20 <?php echo $background["colour"]; ?> <?php echo $text_alignment; ?> <?php echo $textColour; ?>" <?php echo $background["style"]; ?>>
    <?php echo ($background["colour"] == "bg-image") ? '<div class="absolute top-0 left-0 w-full h-full z-10 bg-black/50"></div>' : ""; ?>

    <?php if (!empty(get_sub_field('section_title')) || !empty(get_sub_field('title')) || !empty(get_sub_field('content')) || !empty(get_sub_field('clone_buttons', 'option'))) : ?>
        <div class="container mx-auto relative mb-10 z-20 flex flex-col <?php echo $content_alignment; ?>">
            <div class="max-w-2xl relative z-20">
                <?php render_title(get_sub_field('section_title'), 'p', 'uppercase text-sm font-bold mb-4'); ?>
                <?php render_title(get_sub_field('title'), get_sub_field('title_type'), implode(" ", ['mb-6', $titleFont, $titleStyle])); ?>
                <?php render_content(get_sub_field('content')); ?>
                <?php render_buttons([
                    "buttons" => get_sub_field('clone_buttons', 'option'),
                    "wrapClass" => "flex mt-6 " . $content_alignment,
                ]); ?>
            </div>
        </div>
    <?php endif; ?>

    <div class="container mx-auto relative z-20 flex flex-col <?php echo $content_alignment; ?> animate" data-animate="animate-fade-up animate-delay-[1000ms]">
        <?php if ($videoType == "youtube") : ?>
            <div class="overflow-hidden">
                <?php echo $iframe; ?>
            </div>
        <?php else : ?>
            <video class="lazy aspect-video w-full overflow-hidden" id="video-<?php echo $position; ?>" width="320" height="240" playsinline controls loop autoplay muted>
                <source data-src="<?php echo $videoURL; ?>" type="video/<?php echo $videoExt; ?>">
            </video>
        <?php endif; ?>
    </div>

    <script>
        document.addEventListener("DOMContentLoaded", () => {
            let lazyVideos = [...document.querySelectorAll("video.lazy")]

            if ("IntersectionObserver" in window) {
                let lazyVideoObserver = new IntersectionObserver(function(entries) {
                    entries.forEach(function(video) {
                        if (video.isIntersecting) {
                            for (let source in video.target.children) {
                                let videoSource = video.target.children[source];
                                if (typeof videoSource.tagName === "string" && videoSource.tagName === "SOURCE") {
                                    videoSource.src = videoSource.dataset.src;
                                }
                            }

                            video.target.load();
                            video.target.classList.remove("lazy");
                            lazyVideoObserver.unobserve(video.target);
                        }
                    });
                });

                lazyVideos.forEach(function(lazyVideo) {
                    lazyVideoObserver.observe(lazyVideo);
                });
            }
        });
    </script>


</div>