<?php

// Work out the best text colour based on the background.
$textColour = determin_text_colour(get_sub_field('background_colour'));

// Get the title font.
$titleFont = get_sub_field('title_font');

// Get the title transform.
$titleStyle = get_sub_field('title_style');

// Get the text alignment.
$text_alignment = get_sub_field('text_alignment');
$content_alignment = "";

if ($text_alignment == "text-center") {
    $content_alignment = "items-center justify-center";
}

if ($text_alignment == "text-right") {
    $content_alignment = "items-end justify-end";
}

?>

<div class="relative py-10 px-6 md:py-20 <?php echo $background["colour"]; ?> <?php echo $text_alignment; ?> <?php echo $textColour; ?>" <?php echo $background["style"]; ?>>
    <?php echo ($background["colour"] == "bg-image") ? '<div class="absolute top-0 left-0 w-full h-full z-10 bg-black/50"></div>' : ""; ?>

    <?php if (!empty(get_sub_field('section_title')) || !empty(get_sub_field('title')) || !empty(get_sub_field('content')) || !empty(get_sub_field('clone_buttons', 'option'))) : ?>
        <div class="container mx-auto relative mb-10 z-20 flex flex-col <?php echo $content_alignment; ?>">
            <div class="max-w-2xl relative z-20">
                <?php render_title(get_sub_field('section_title'), 'p', 'uppercase text-sm font-bold mb-4'); ?>
                <?php render_title(get_sub_field('title'), get_sub_field('title_type'), implode(" ", ['mb-6', $titleFont, $titleStyle])); ?>
                <?php render_content(get_sub_field('content')); ?>
                <?php render_buttons([
                    "buttons" => get_sub_field('clone_buttons', 'option'),
                    "wrapClass" => "flex mt-6 " . $content_alignment,
                ]); ?>
            </div>
        </div>
    <?php endif; ?>

    <div class="container mx-auto relative animate" data-animate="animate-fade-up animate-delay-[1000ms]">
        <figure class="relative aspect-video bg-primary flex items-center justify-center overflow-hidden">
            <?php 
            if (!empty(get_sub_field('image'))) {
                render_image(get_sub_field('image'), 'video', true, 'object-cover object-center w-full h-full');
            } else {
                render_image(get_field('block_video_thumbnail_fallback_image', 'option'), 'large', true);
            }
            ?>
            <div class="hidden md:flex absolute bottom-0 left-0 right-0 bg-gradient-to-b from-white/20 to-black/10 h-32 w-full items-center justify-center">
                <span class="text-2xl lead uppercase tracking-wider font-normal <?php echo determin_text_colour('bg-primary'); ?>"><?php echo __('Click to Play Video', 'pharmodigital'); ?></span>
            </div>
        </figure>
        <a href="<?php echo get_sub_field('video'); ?>" data-fancybox="video-<?php echo $position; ?>" class="absolute fill-white top-0 left-0 w-full h-full flex items-center justify-center">
            <div class="top-1/2 left-1/2 w-8 translate">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512">
                    <path d="M73 39c-14.8-9.1-33.4-9.4-48.5-.9S0 62.6 0 80V432c0 17.4 9.4 33.4 24.5 41.9s33.7 8.1 48.5-.9L361 297c14.3-8.7 23-24.2 23-41s-8.7-32.2-23-41L73 39z" />
                </svg>
                <span class="flaticon-play-arrow">
                    <i class="ripple"></i>
                </span>
            </div>
        </a>
    </div>
</div>

<style>
    .fancybox__content :focus:not(.carousel__button.is-close) {
        outline: none;
    }

    .ripple,
    .ripple:before,
    .ripple:after {
        position: absolute;
        top: 50%;
        left: 50%;
        width: 110px;
        height: 110px;
        -webkit-transform: translate(-50%, -50%);
        -moz-transform: translate(-50%, -50%);
        -ms-transform: translate(-50%, -50%);
        -o-transform: translate(-50%, -50%);
        transform: translate(-50%, -50%);
        -webkit-border-radius: 50%;
        -moz-border-radius: 50%;
        -ms-border-radius: 50%;
        -o-border-radius: 50%;
        border-radius: 50%;
        -webkit-box-shadow: 0 0 0 0 rgba(255, 255, 255, .6);
        -moz-box-shadow: 0 0 0 0 rgba(255, 255, 255, .6);
        -ms-box-shadow: 0 0 0 0 rgba(255, 255, 255, .6);
        -o-box-shadow: 0 0 0 0 rgba(255, 255, 255, .6);
        box-shadow: 0 0 0 0 rgba(255, 255, 255, .6);
        -webkit-animation: ripple 3s infinite;
        -moz-animation: ripple 3s infinite;
        -ms-animation: ripple 3s infinite;
        -o-animation: ripple 3s infinite;
        animation: ripple 3s infinite;
    }

    .ripple:before {
        -webkit-animation-delay: .9s;
        -moz-animation-delay: .9s;
        -ms-animation-delay: .9s;
        -o-animation-delay: .9s;
        animation-delay: .9s;
        content: "";
        position: absolute;
    }

    .ripple:after {
        -webkit-animation-delay: .6s;
        -moz-animation-delay: .6s;
        -ms-animation-delay: .6s;
        -o-animation-delay: .6s;
        animation-delay: .6s;
        content: "";
        position: absolute;
    }

    @-webkit-keyframes ripple {
        70% {
            box-shadow: 0 0 0 70px rgba(253, 167, 0, 0);
        }

        100% {
            box-shadow: 0 0 0 0 rgba(253, 167, 0, 0);
        }
    }

    @keyframes ripple {
        70% {
            box-shadow: 0 0 0 70px rgba(253, 167, 0, 0);
        }

        100% {
            box-shadow: 0 0 0 0 rgba(253, 167, 0, 0);
        }
    }
</style>