<?php

$page_title = get_field('posts_archive_title', 'option');

if (is_archive()) {
    $page_title = strtoupper(get_the_archive_title());
}

// Animation delay options.
$animation_delay = ['animate-delay-0', 'animate-delay-300', 'animate-delay-[500ms]', 'animate-delay-[700ms]'];
$animation_delay_quick = ['animate-delay-0', 'animate-delay-[1200ms]', 'animate-delay-[1300ms]', 'animate-delay-[1400ms]', 'animate-delay-[1500ms]', 'animate-delay-[1600ms]', 'animate-delay-[1700ms]', 'animate-delay-[1800ms]', 'animate-delay-[1900ms]'];

?>

<?php if (get_field('enabled_archive_title', 'option')) : ?>

    <?php if (!empty(get_field('enabled_post_feature_image_banner', 'option'))) : ?>
        <div class="relative flex items-center justify-center h-[80vh]">
            <?php render_image(get_field('posts_archive_background', 'option'), 'full', false, 'absolute top-0 left-0 w-full h-full object-cover object-center'); ?>

            <div class="relative container mx-auto flex tems-center justify-center w-full z-20 px-6">
                <div class="py-4 px-8 -mb-6 inline-block text-white max-w-4xl">
                    <?php render_title(get_field('posts_archive_section_title', 'option'), 'p', trim('text-center mx-auto text-xl md:text-2xl max-w-5xl uppercase font-display font-bold'), 'animate-fade-up'); ?>
                    <?php render_title($page_title, 'h1', trim('text-center mx-auto text-4xl md:text-5xl max-w-5xl font-display font-bold'), 'animate-fade-up animate-delay-500'); ?>
                    <?php render_content(get_field('posts_archive_content', 'option'), 'max-w-2xl mx-auto animate', 'text-sm md:text-base text-center font-medium', 'animate-fade-up animate-delay-1000'); ?>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <div class="bg-smoke py-4">
        <div class="container mx-auto px-6">
            <?php view('components.breadcrumbs', null, null, ['class' => 'bg-smoke text-sm']); ?>
        </div>
    </div>

<?php endif; ?>

<div class="bg-white text-black">
    <div class="container mx-auto px-6 pt-10">
        <main>

            <?php if (get_post_type() == "post" && get_field(get_post_type() . "_index_include_categories_list", 'option')) :
                $non_active_classes = "py-2 px-3 md:px-6 no-underline flex items-center justify-center ease-in-out duration-300 hover:no-underline hover:border-black";
            ?>
                <div class="my-10 flex items-center justify-center gap-2 md:gap-4 flex-wrap">
                    <a href="<?php echo get_the_permalink(get_option('page_for_posts')); ?>" class="<?php echo $non_active_classes; ?> <?php echo (is_home()) ? "border border-black text-black hover:text-black" : "text-black hover:text-primary"; ?> animate" data-animate="animate-fade-up <?php echo $animation_delay_quick[2]; ?>">All</a>
                    <?php
                    $categories = get_categories();
                    $pageCategory = get_queried_object();
                    foreach ($categories as $key => $category) :
                        $current = ($pageCategory->term_id == $category->term_id) ? true : false;
                    ?>
                        <a href="<?php echo get_term_link($category); ?>" class="<?php echo $non_active_classes; ?> <?php echo ($current) ? "border border-black text-black hover:text-black" : "text-black hover:text-primary"; ?> animate" title="<?php echo $category->name; ?>" data-animate="animate-fade-up <?php echo $animation_delay_quick[$key + 2]; ?>"><?php echo $category->name; ?></a>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>

            <div class="blog-posts grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 pt-10 pb-20 animate" data-animate="animate-fade-up">
                <?php
                if (have_posts()) :
                    $i = 1;
                    while (have_posts()) :
                        the_post();

                        $gridWidth = "";
                        if ($i === 1 || $i === 7)
                            $gridWidth = " col-span-2";

                        view('blog.post', null, null, ["spacing" => "mb-4" . $gridWidth]);

                        $i++;
                    endwhile;
                endif;
                ?>
            </div>
            <?php view('components.pagination'); ?>
        </main>
    </div>
</div>