<?php

// Get the post category or primary category from RankMath.
$postCategory = "";
if (class_exists('RankMath')) {
    $postCategory = get_post_meta(get_the_id(), 'rank_math_primary_category', true);
    $postCategory = get_category($postCategory, 'OBJECT');
} else {
    $postCategory = get_the_category()[0];
}

?>

<article class="post overflow-hidden text-left flex flex-col <?php echo (isset($data['spacing'])) ? $data['spacing'] : ""; ?>">

    <div class="h-96 aspect-square w-full overflow-hidden">
        <a href="<?php echo get_the_permalink(); ?>" class="group">
            <?php render_image(array("ID" => get_post_thumbnail_id()), 'content-width', true, 'w-full h-full object-cover object-center group-hover:scale-110 ease-in-out duration-500'); ?>
        </a>
    </div>
    <div class="pt-6 flex flex-col grow justify-between">
        <div class="mb-4">
            <div class="flex w-full justify-between mb-4">
                <?php
                if (!empty($postCategory) && !is_wp_error($postCategory)) :
                ?>
                    <div>
                        <a href="<?php echo get_category_link($postCategory); ?>" class="inline-block text-black/40 text-xs font-medium px-3 py-1 no-underline border border-black/20 border-solid hover:bg-primary hover:text-white hover:border-priamry ease-in-out duration-500">
                            <?php echo $postCategory->name; ?>
                        </a>
                    </div>
                <?php
                endif;
                ?>
                <p class="block mb-0 text-sm opacity-60"><?php echo get_the_date('jS F Y'); ?></p>
            </div>
            <?php render_title(wp_trim_words(get_the_title(), 10, "..."), 'h2', 'text-lg font-thin md:text-2xl leading-none'); ?>
            <?php render_content(wp_trim_words(get_the_excerpt(), 35, "..."), 'text-sm mb-0'); ?>
        </div>
        <div class="inline-block">
            <?php
            render_buttons([
                "buttons" => array(
                    array(
                        "link" => array(
                            "url" => get_the_permalink(),
                            "title" => "Read article"
                        ),
                        "style" => "text",
                        "colour" => "black"
                    ),
                ),
                "size" => "small",
                "remove_class" => "mb-2"
            ]);
            ?>
        </div>
    </div>

</article>