<?php

// Get the post category or primary category from RankMath.
$postCategory = "";
if (class_exists('RankMath')) {
    $postCategory = get_post_meta(get_the_id(), 'rank_math_primary_category', true);
    $postCategory = get_category($postCategory, 'OBJECT');
} else {
    $postCategory = get_the_category()[0];
}

?>

<?php if (!empty(get_field('enabled_post_feature_image_banner', 'option'))) : ?>
    <div class="relative flex items-center justify-center h-[80vh]">
        <?php render_image(array("ID" => get_post_thumbnail_id()), 'full', false, 'absolute top-0 left-0 w-full h-full object-cover object-center'); ?>

        <div class="relative container mx-auto flex tems-center justify-center w-full z-20 px-6">
            <div class="py-4 px-8 -mb-6 inline-block text-white max-w-4xl">
                <?php render_title(get_the_title(), 'h1', trim('text-center mx-auto text-4xl md:text-5xl max-w-5xl font-display font-bold'), 'animate-fade-up'); ?>
                <?php if (!empty(has_excerpt())) : ?>
                    <?php render_content(get_the_excerpt(), 'max-w-2xl mx-auto animate', 'text-sm md:text-base text-center font-medium', 'animate-fade-up animate-delay-1000'); ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php endif; ?>
<div class="bg-smoke py-4">
    <div class="container mx-auto px-6">
        <?php view('components.breadcrumbs', null, null, ['class' => 'bg-smoke text-sm']); ?>
    </div>
</div>

<!-- Main Post Content -->
<div class="post">

    <div class="container mx-auto px-6 pt-20 flex flex-wrap">
        <main class="w-full md:w-8/12 mb-20 md:mb-0">
            <div class="flex justify-between items-center mt-4 text-sm">
                <div class="flex items-center gap-2"><svg class="h-5 fill-primary" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><!--!Font Awesome Pro 6.6.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2024 Fonticons, Inc.-->
                        <path d="M128 0l0 16 0 48 192 0 0-48 0-16 32 0 0 16 0 48 64 0 32 0 0 32 0 64 0 32 0 288 0 32-32 0L32 512 0 512l0-32L0 192l0-32L0 96 0 64l32 0 64 0 0-48L96 0l32 0zM416 192L32 192l0 288 384 0 0-288zm0-96L32 96l0 64 384 0 0-64z" />
                    </svg><?php echo get_the_date('jS F Y'); ?></div>
            </div>

            <hr class="border-primary my-4 border-b-1 opacity-40">

            <?php render_title(get_the_title(), 'p', trim('text-2xl md:text-3xl max-w-5xl font-display py-6')); ?>

            <?php if (!empty(get_field('enabled_post_feature_image', 'option'))) : ?>
                <?php render_image(array("ID" => get_post_thumbnail_id()), 'content_width', false, 'w-full my-4'); ?>
            <?php endif; ?>

            <?php render_content(get_the_content()); ?>

            <hr class="border-primary my-4 border-b-1 opacity-40">

            <?php if (!empty(get_field('enabled_post_share', 'option'))) : ?>
                <div class="flex items-center gap-4">
                    <div>
                        <p class="md:mb-0">Share this to:</p>
                    </div>
                    <?php view('components.share', null, null, [
                        "wrapClass" => "list-none flex ml-0 my-4 p-0",
                        "class" => "'w-8 h-8 flex items-center justify-center mx-1 px-2 fill-black hover:bg-black hover:fill-white ease-in-out duration-500",
                        "svgClass" => "w-4 h-4",
                    ]); ?>
                </div>
            <?php endif; ?>

        </main>

        <?php get_sidebar(); ?>

    </div>


    <?php if (!empty(get_field('enabled_post_related', 'option'))) : ?>
        <div class="container mx-auto px-6 mb-10 md:mt-20 md:mb-32">
            <?php render_title(get_field('post_single_related_posts_title', 'option'), 'h2', 'text-center text-2xl md:text-4xl mb-12'); ?>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                <?php
                $args = array(
                    'posts_per_page' => 3,
                    'post_type' => 'post',
                    'post_status' => 'publish',
                    'post__not_in' => [get_the_id()]
                );
                $posts = new WP_Query($args);
                if ($posts->have_posts()) {
                    while ($posts->have_posts()) {
                        $posts->the_post();
                        view('blog.post');
                    }
                }
                wp_reset_postdata();
                ?>
            </div>
        </div>
    <?php endif; ?>

</div>

<?php

// Set up access to the blocks variables. 
global $pageID;
global $pageName;

// Include global directory blocks.
$pageName = get_post_type() . "_single_blocks_blocks";
$pageID = 'options';

// Load the blocks system.
view('blocks.blocks');

?>