<?php 
/**
 * PHONE NUMBER SHORTCODE
 * ------------------------------------------------
 * This shortcode outputs the contact phone 
 * number from the theme settings.
 * 
 * @return $return | String
 */
function phone_shortcode_function($class = null) {
    $return = "";

    if (!empty(get_field('phone_number', 'option')['url']) && !empty(get_field('phone_number', 'option')['title'])) {

        $phone_url = get_field('phone_number', 'option')['url'];
        $phone_text = get_field('phone_number', 'option')['title'];
        $return = "<a class='inherit hover:inherit hover:underline {$class}' title='Call us' href='{$phone_url}'>{$phone_text}</a>";

    }

    return $return;
}
add_shortcode('phone-number', 'phone_shortcode_function');



/**
 * EMAIL ADDRESS SHORTCODE
 * ------------------------------------------------
 * This shortcode outputs the email address
 * from the theme settings.
 * 
 * @return $return | String
 */
function email_shortcode_function($class = null) {
    $return = "";

    if (!empty(get_field('email_address', 'option')['url']) && !empty(get_field('email_address', 'option')['title'])) {

        $email_url = get_field('email_address', 'option')['url'];
        $email_text = get_field('email_address', 'option')['title'];
        $return = "<a class='inherit hover:inherit hover:underline {$class}' title='Email Us' href='{$email_url}'>{$email_text}</a>";

    }

    return $return;
}
add_shortcode('email-address', 'email_shortcode_function');



/**
 * POSTAL ADDRESS SHORTCODE
 * ------------------------------------------------
 * This shortcode outputs the postal address
 * from the theme settings.
 * 
 * @return $return | String
 */
function address_shortcode_function($class = null) {
    $return = "";

    if (!empty(get_field('address', 'option'))) {

        $address = get_field('address', 'option');
        $return = "<p class='inherit hover:inherit hover:underline {$class}'>{$address}</p>";

    }

    return $return;
}
add_shortcode('address', 'email_shortcode_function');



/**
 * SOCIAL ICONS SHORTCODE
 * ------------------------------------------------
 * This shortcode outputs the content from
 * the social shortcode funcation.
 * 
 * @return $html | string
 */
function social_shortcode_function() {
    return render_social_icons();
}
add_shortcode('social-icons', 'social_shortcode_function');