<?php do_action('ejweddingsandevents_content_after'); ?>

<footer id="colophon" class="relative mt-10 px-6 pt-10 md:pt-10 bg-black text-white" role="contentinfo">

    <div class="container mx-auto grid grid-cols-1 md:grid-cols-2 gap-6">
        <div>
            <a href="<?php echo home_url(); ?>" title="<?php bloginfo('name'); ?> Homepage">
                <?php render_image(get_field('footer_logo', 'option'), array(200, 200), true, 'mb-6 max-w-[13rem]'); ?>
            </a>
            <?php render_content(get_field('footer_content', 'option'), 'text-left font-display max-w-lg font-thin mb-0', 'leading-normal'); ?>
        </div>

        <div class="flex md:items-end md:justify-end">
            <div>
                <?php render_social_icons('list-none flex justify-end ml-0 my-4 p-0', 'w-8 h-8 flex items-center justify-center mx-1 fill-white hover:bg-primary hover:fill-black ease-in-out duration-500', 'w-4 h-4'); ?>
                <?php
                if (!empty($button = get_field('footer_button', 'option'))) {
                    render_buttons([
                        "buttons" => array(
                            array(
                                "link" => array(
                                    "url" => $button['url'],
                                    "title" => $button['title']
                                ),
                                "style" => "keyline",
                                "colour" => "white"
                            )
                        ),
                        "buttonClass" => 'w-full bg-primary',
                        "wrapClass" => "my-4"
                    ]);
                }
                ?>
            </div>
        </div>
    </div>

    <div class="w-full text-white border-solid border-t border-[#ffffff6b] py-4 mt-10 flex items-center flex-wrap justify-between">
        <p class="text-xs text-center mb-0 "><?php echo str_replace("{{year}}", date('Y'), get_field('footer_copyright_message', 'option')); ?></p>
        <p class="text-xs mb-0">Website by <a href="https://sixsearch.co.uk" class="text-inherit underline hover:text-black hover:underline">Six Search</a></p>
    </div>
</footer>