<?php if (get_field('header_show_notice', 'option')) : ?>
    <div class="notice-banner fixed w-full z-50 bg-primary py-2 text-base text-white hover:text-white flex gap-3 items-center justify-center">
        <?php if (!empty(get_field('header_notice_link', 'option'))) : ?>
            <a href="<?php echo get_field('header_notice_link', 'option')['url']; ?>" class="text-white hover:text-white no-underline flex items-center gap-1 fill-black hover:fill-white">
            <?php endif; ?>

            <?php if (!empty(get_field('header_notice_content', 'option'))) : ?>
                <div><?php echo get_field('header_notice_content', 'option'); ?></div>
            <?php endif; ?>

            <?php if (!empty(get_field('header_notice_link', 'option'))) : ?>
            </a>
        <?php endif; ?>
    </div>
<?php endif; ?>

<header class="fixed bg-black z-40 2xl:pl-0 w-full" data-menu-state="0" data-scrolled="0">
    <div class="relative bg-black z-40 max-w-7xl pl-6 mx-auto flex justify-between">
        <div class="flex items-center">
            <a href="<?php echo home_url(); ?>" title="<?php bloginfo('name'); ?> Homepage" class="block mr-8 mb-2 md:mr-10 lg:mr-16">
                <?php render_image(get_field('footer_logo', 'option'), array(260, 80), true, 'logo w-full h-full max-w-[24rem]'); ?>
            </a>

            <div class="hidden header-breakpoint:block desktop-menu" data-menu="desktop">
                <?php
                wp_nav_menu(array(
                    'theme_location' => 'desktop-menu',
                    'container' => 'div',
                ));
                ?>
            </div>
        </div>
    <div class="flex-1 flex items-center justify-end gap-6">
            <div class="text-right text-sm gap-2">
                <?php if (!empty(get_field('phone_number', 'option'))) : ?>
                    <div class="hidden md:flex flex-col">
                        <?php if (!empty(get_field('header_contact_label', 'option'))) : ?>
                            <span class="uppercase text-xs"><?php echo get_field('header_contact_label', 'option'); ?></span>
                        <?php endif; ?>
                        <a href="tel:<?php echo get_field('phone_number', 'option')['url']; ?>" class="text-inherit no-underline hover:text-primary"><?php echo get_field('phone_number', 'option')['title']; ?></a>
                    </div>
                <?php endif; ?>
                <?php if (!empty(get_field('email_address', 'option'))) : ?>
                    <div class="hidden md:flex flex-col">
                        <?php if (!empty(get_field('header_contact_label', 'option'))) : ?>
                            <span class="uppercase text-xs"><?php echo get_field('header_contact_label', 'option'); ?></span>
                        <?php endif; ?>
                        <a href="tel:<?php echo get_field('email_address', 'option')['url']; ?>" class="text-inherit no-underline hover:text-primary"><?php echo get_field('email_address', 'option')['title']; ?></a>
                    </div>
                <?php endif; ?>

            </div>
            <div class="hidden header-breakpoint:block">
                <?php
                if (!empty($button = get_field('header_button', 'option'))) {
                    render_buttons([
                        "buttons" => array(
                            array(
                                "link" => array(
                                    "url" => $button['url'],
                                    "title" => $button['title']
                                ),
                                "style" => "solid",
                                "colour" => "primary"
                            )
                        ),
                        "buttonClass" => 'h-full bg-primary hover:bg-primary py-10 mb-0',
                        "wrapClass" => "text-center",
                        "remove_class" => "mb-4"
                    ]);
                }
                ?>
            </div>
            <div class="header-breakpoint:hidden">
                <div class="h-full bg-primary hover:bg-primary p-6 mb-0">
                    <label class="hamburger" for="check" title="Toggle Mobile Menu">
                        <input type="checkbox" id="check" />
                        <span></span>
                        <span></span>
                        <span></span>
                    </label>
                </div>
            </div>
        </div>
    </div>

    <div data-menu="mobile-menu">
        <?php
        wp_nav_menu(array(
            "theme_location" => "mobile-menu",
        ));
        ?>
    </div>

</header>
<div class="header-clear"></div>