<div class="relative flex items-center justify-center min-h-[20rem] md:min-h-[30rem]">
    <?php render_image(get_field('property_index_banner_background', 'option'), 'full', false, 'absolute top-0 left-0 w-full h-full object-cover object-center'); ?>

    <div class="relative container mx-auto w-full z-20 px-6">
        <div class="py-4 px-8 -mb-6 inline-block text-white backdrop-blur-sm backdrop-brightness-75">
            <?php render_title(get_field('property_index_banner_title', 'option'), 'h1', 'mt-4 mb-0 leading-none'); ?>
            <?php render_content(get_field('property_index_banner_content', 'option'), 'max-w-2xl mt-6'); ?>
        </div>
    </div>
</div>
<div class="bg-smoke py-4">
    <div class="container mx-auto px-6">
        <?php view('components.breadcrumbs', null, null, ['class' => 'bg-smoke']); ?>
    </div>
</div>

<div class="container mx-auto mt-10 px-6">

    <div class="px-6 grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-10 md:-mx-6">

        <?php
        $args = array(
            'posts_per_page' => -1,
            'post_type' => 'property',
            'post_status' => 'publish',
        );
        $posts = new WP_Query($args);
        if ($posts->have_posts()) {
            while ($posts->have_posts()) {
                $posts->the_post();
                view('property.post-portrait');
            }
        }
        wp_reset_postdata();
        ?>

    </div>

    <hr class="border-primary mb-4 border-b-1 opacity-40">

</div>

<?php

// Set up access to the blocks variables. 
global $pageID;
global $pageName;

// Include global directory blocks.
$pageName = get_post_type() . "_index_blocks_blocks";
$pageID = 'options';

// Load the blocks system.
view('blocks.blocks');

?>