<article class="post h-full mb-6 flex <?php echo (isset($data['classes'])) ? $data['classes'] : ""; ?>">
    <a href="<?php echo get_the_permalink(); ?>" class="flex flex-col w-full text-black hover:text-black text-sm no-underline hover:no-underline hover:bg-smoke group">
        <div class="relative thumbnail <?php echo (!empty(get_field('featured_image_landscape'))) ? get_field('featured_image_landscape') : "bg-smoke"; ?> w-full h-60 overflow-hidden ease-in-out duration-200">
            <?php render_image(get_field('featured_image_landscape'), 'square', true, 'object-cover object-center w-full h-full group-hover:scale-105 ease-in-out duration-500'); ?>
        </div>
        <div class="p-4">
            <?php render_title(get_the_title(), 'h4'); ?>
            <?php render_content(get_field('excerpt')); ?>

            <div class="flex gap-4 text-lg text-primary">
                <?php
                $show_icons = ['air-conditioning', 'wifi', 'jacuzzi', 'swimming-pool', 'bbqs', 'safe', 'car-parking'];
                foreach (get_field('facilities') as $facility) {
                    $term = get_term_by('term_id', $facility, 'facility');
                    if (in_array($term->slug, $show_icons)) {
                        $icon = get_field('icon', $term->taxonomy . '_' . $term->term_id);
                        echo "<i class='{$icon->class}' title='{$term->name}'></i>";
                    }
                }
                ?>
            </div>
        </div>
    </a>
</article>