<article class="post h-full <?php echo (isset($data['classes'])) ? $data['classes'] : ""; ?>">
    <a href="<?php echo get_the_permalink(); ?>" class="flex flex-col w-full text-black hover:text-black text-sm no-underline hover:no-underline group">
        <div class="relative thumbnail bg-smoke w-full aspect-[1/1.4] overflow-hidden ease-in-out duration-200">
            <?php render_image(get_field('featured_image_portrait'), 'square', true, 'object-cover object-center w-full h-full group-hover:scale-105 ease-in-out duration-500'); ?>
            <div class="absolute top-10 left-0 py-2 px-4 bg-white">
                <?php if (!empty(get_field('total_guests'))) : ?>
                    <div class="flex items-center gap-2">
                        <svg class="h-5 fill-primary" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><!--!Font Awesome Pro 6.6.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2024 Fonticons, Inc.-->
                            <path d="M80 80a64 64 0 1 1 128 0A64 64 0 1 1 80 80zm144 0A80 80 0 1 0 64 80a80 80 0 1 0 160 0zm96 64a80 80 0 1 1 0 160 80 80 0 1 1 0-160zm0 176a96 96 0 1 0 0-192 96 96 0 1 0 0 192zM187.9 368l264.2 0 38.4 128-341 0 38.4-128zM464 352l-288 0L132.8 496 128 512l16.7 0 350.6 0 16.7 0-4.8-16L464 352zM196 192L48 192 6 304l17.1 0 36-96L193 208c.7-5.4 1.7-10.8 3-16zM444 192c1.3 5.2 2.4 10.6 3 16l133.9 0 36 96 17.1 0L592 192l-148 0zm4-112a64 64 0 1 1 128 0A64 64 0 1 1 448 80zm144 0A80 80 0 1 0 432 80a80 80 0 1 0 160 0z" />
                        </svg>
                        <span><?php echo get_field('total_guests'); ?> guests</span>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <div class="pt-4 flex flex-col justify-between">
            <div>
                <?php render_title(get_the_title(), 'h4'); ?>
                <?php render_content(get_field('excerpt')); ?>
            </div>
            <div>
                <div class="flex gap-4 text-lg text-primary">
                    <?php
                    $show_icons = ['air-conditioning', 'wifi', 'jacuzzi', 'swimming-pool', 'bbqs', 'safe', 'car-parking'];
                    foreach (get_field('facilities') as $facility) {
                        $term = get_term_by('term_id', $facility, 'facility');
                        if (in_array($term->slug, $show_icons)) {
                            $icon = get_field('icon', $term->taxonomy . '_' . $term->term_id);
                            echo "<i class='{$icon->class}' title='{$term->name}'></i>";
                        }
                    }
                    ?>
                </div>
                <?php
                    render_buttons([
                        "buttons" => array(
                            array(
                                "link" => array(
                                    "url" => get_the_permalink(),
                                    "title" => get_field('property_index_view_property_label', 'option')
                                ),
                                "style" => "keyline",
                                "colour" => "primary"
                            )
                        ),
                        "size" => "small",
                        "link" => false,
                        "wrapClass" => "mt-6", 
                        "remove_class" => "mb-4"
                    ]);
                ?>
            </div>
        </div>
    </a>
</article>