    <div class="container mx-auto">
        <main class="px-6">

            <?php view('components.breadcrumbs', null, null, ['class' => 'bg-white mb-4']); ?>

            <div class="relative bg-smoke h-[75vh] md:h-[50vh] max-h-[56rem] overflow-hidden">
                <div class="swiper-property-gallery w-full h-full">
                    <div class="swiper-wrapper">
                        <?php
                        if (!empty(get_field('gallery'))) {
                            echo '<div class="swiper-slide">';
                            render_image(get_field('featured_image_landscape'), 'property_gallery', true, 'w-full h-full object-cover object-center');
                            echo '</div>';
                            foreach (get_field('gallery') as $image) {
                                echo '<div class="swiper-slide">';
                                render_image($image, 'property_gallery', true, 'w-full h-full object-cover object-center');
                                echo '</div>';
                            }
                        }
                        ?>
                    </div>
                </div>

                <div class="absolute z-10 left-0 md:left-auto md:right-[5%] bottom-0 backdrop-blur-sm backdrop-brightness-75 text-white max-w-md p-8">
                    <?php render_title(get_the_title(), 'h1', 'mb-0'); ?>
                </div>
            </div>

            <div class="flex flex-wrap mt-10 px-6 2xl:px-0">
                <div class="w-full md:w-2/3 md:pr-8">
                    <?php render_title("About " . get_the_title(), 'h2'); ?>

                    <div class="my-6 flex flex-wrap gap-10 text-sm">
                        <?php if (!empty(get_field('total_guests'))) : ?>
                            <div class="flex items-center gap-2">
                                <svg class="h-5 fill-primary" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><!--!Font Awesome Pro 6.6.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2024 Fonticons, Inc.-->
                                    <path d="M80 80a64 64 0 1 1 128 0A64 64 0 1 1 80 80zm144 0A80 80 0 1 0 64 80a80 80 0 1 0 160 0zm96 64a80 80 0 1 1 0 160 80 80 0 1 1 0-160zm0 176a96 96 0 1 0 0-192 96 96 0 1 0 0 192zM187.9 368l264.2 0 38.4 128-341 0 38.4-128zM464 352l-288 0L132.8 496 128 512l16.7 0 350.6 0 16.7 0-4.8-16L464 352zM196 192L48 192 6 304l17.1 0 36-96L193 208c.7-5.4 1.7-10.8 3-16zM444 192c1.3 5.2 2.4 10.6 3 16l133.9 0 36 96 17.1 0L592 192l-148 0zm4-112a64 64 0 1 1 128 0A64 64 0 1 1 448 80zm144 0A80 80 0 1 0 432 80a80 80 0 1 0 160 0z" />
                                </svg>
                                <span><?php echo get_field('total_guests'); ?> guests</span>
                            </div>
                        <?php endif; ?>
                        <?php if (!empty(get_field('size'))) : ?>
                            <div class="flex items-center gap-2">
                                <svg class="h-5 fill-primary" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><!--!Font Awesome Pro 6.6.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2024 Fonticons, Inc.-->
                                    <path d="M290.3 210.3l-5.7 5.7L296 227.3l5.7-5.7L496 27.3 496 168l0 8 16 0 0-8L512 8l0-8-8 0L344 0l-8 0 0 16 8 0 140.7 0L290.3 210.3zm-68.7 91.3l5.7-5.7L216 284.7l-5.7 5.7L16 484.7 16 344l0-8L0 336l0 8L0 504l0 8 8 0 160 0 8 0 0-16-8 0L27.3 496 221.7 301.7z" />
                                </svg>
                                <span><?php echo get_field('size'); ?></span>
                            </div>
                        <?php endif; ?>
                        <?php if (!empty(get_field('bedrooms'))) : ?>
                            <div class="flex items-center gap-2">
                                <svg class="h-5 fill-primary" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><!--!Font Awesome Pro 6.6.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2024 Fonticons, Inc.-->
                                    <path d="M40 32l-8 0 0 8 0 88 0 8 0 88L8 224l-8 0 0 8L0 408l0 64c0 4.4 3.6 8 8 8s8-3.6 8-8l0-56 480 0 0 56 0 8 16 0 0-8 0-64 0-176 0-8-8 0-24 0 0-88 0-8 0-88 0-8-8 0L40 32zm8 112l200 0 0 80L48 224l0-80zm200-16L48 128l0-80 416 0 0 80-200 0-8 0-8 0zm16 16l200 0 0 80-200 0 0-80zm0 96l200 0 16 0 16 0 0 160L16 400l0-160 16 0 16 0 200 0 16 0z" />
                                </svg>
                                <span><?php echo get_field('bedrooms'); ?> bedrooms</span>
                            </div>
                        <?php endif; ?>
                        <?php if (!empty(get_field('bathrooms'))) : ?>
                            <div class="flex items-center gap-2">
                                <svg class="h-5 fill-primary" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><!--!Font Awesome Pro 6.6.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2024 Fonticons, Inc.-->
                                    <path d="M32 0l8 0 64 0 3.3 0 2.3 2.3 45.4 45.4C167.4 37.9 183 32 200 32c23.1 0 43.7 10.9 56.9 27.8l1.5-1.5 5.7-5.7L275.3 64l-5.7 5.7-104 104-5.7 5.7L148.7 168l5.7-5.7 1.5-1.5C138.9 147.7 128 127.1 128 104c0-17 5.9-32.6 15.7-44.9L100.7 16 48 16l0 256 416 0 16 0 24 0 8 0 0 16-8 0-24 0-16 0L48 288l-16 0L8 288l-8 0 0-16 8 0 24 0L32 8l0-8zm0 320l16 0 0 48c0 53 43 96 96 96l224 0c53 0 96-43 96-96l0-48 16 0 0 48c0 38.1-19 71.7-48 91.9l0 44.1 0 8-16 0 0-8 0-34.8c-14.5 6.9-30.8 10.8-48 10.8l-224 0c-17.2 0-33.5-3.9-48-10.8L96 504l0 8-16 0 0-8 0-44.1C51 439.7 32 406.1 32 368l0-48zM200 48c-30.9 0-56 25.1-56 56c0 18.7 9.2 35.3 23.3 45.4l78.2-78.2C235.3 57.2 218.7 48 200 48z" />
                                </svg>
                                <span><?php echo get_field('bathrooms'); ?> bathrooms</span>
                            </div>
                        <?php endif; ?>
                        <?php if (!empty(get_field('location'))) : ?>
                            <div class="flex items-center gap-2">
                                <svg class="h-5 fill-primary" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><!--!Font Awesome Pro 6.6.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2024 Fonticons, Inc.-->
                                    <path d="M368 192c0-97.2-78.8-176-176-176S16 94.8 16 192c0 24.1 10.6 55.3 28.2 90c17.5 34.2 40.9 70 64.7 102.6c23.7 32.6 47.4 61.8 65.3 82.8c7 8.2 13 15.2 17.8 20.6c4.8-5.4 10.8-12.4 17.8-20.6c17.8-21 41.6-50.2 65.3-82.8c23.7-32.6 47.2-68.4 64.7-102.6c17.7-34.7 28.2-65.9 28.2-90zm16 0c0 95.9-140.8 262.2-181.3 308c-6.8 7.7-10.7 12-10.7 12s-4-4.3-10.7-12C140.8 454.2 0 287.9 0 192C0 86 86 0 192 0S384 86 384 192zM192 112a80 80 0 1 1 0 160 80 80 0 1 1 0-160zm64 80a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z" />
                                </svg>
                                <span><?php echo get_field('location'); ?></span>
                            </div>
                        <?php endif; ?>
                    </div>

                    <?php render_content(get_field('description')); ?>

                    <div class="mt-10">
                        <?php render_title(get_field('facilities_section_title', 'option'), 'h3', 'mb-6'); ?>

                        <ul class="list-none m-0 mb-4 p-0 columns-2">
                            <?php
                            foreach (get_field('facilities') as $facility) {
                                $term = get_term_by('term_id', $facility, 'facility');
                                $icon = get_field('icon', $term->taxonomy . '_' . $term->term_id);
                                echo "
                                    <li class='flex items-center gap-3'>
                                        <i class='text-primary {$icon->class}' title='{$term->name}'></i>
                                        <span>{$term->name}</span>
                                    </li>";
                            }
                            ?>
                        </ul>
                        <?php if (!empty(!empty(get_field('breakdown')) && count(get_field('breakdown')) > 0)) : ?>
                            <?php render_content(get_field('view_breakdown_section_message')); ?>
                        <?php endif; ?>
                        <?php
                        if (!empty($button = get_field('booking_link'))) {
                            render_buttons([
                                "buttons" => array(
                                    array(
                                        "link" => array(
                                            "url" => $button,
                                            "title" => get_field('reservation_button_label', 'option')
                                        ),
                                        "style" => "solid",
                                        "colour" => "secondary",
                                        "class" => 'w-full mt-4 bg-primary font-bold',
                                    )
                                ),
                                "wrapClass" => "md:hidden"
                            ]);
                        }
                        ?>
                    </div>

                    <div class="mt-10">
                        <hr class="border-primary my-10 border-b-1 opacity-40">

                        <?php render_title(get_field('map_section_title', 'option'), 'h3'); ?>
                        <?php
                        $location = get_field('google_map');
                        if ($location) : ?>
                            <div class="acf-map" data-zoom="16">
                                <div class="marker" data-lat="<?php echo esc_attr($location['lat']); ?>" data-lng="<?php echo esc_attr($location['lng']); ?>"></div>
                            </div>
                        <?php endif; ?>

                        <hr class="border-primary my-10 border-b-1 opacity-40">
                    </div>

                    <?php if (!empty(!empty(get_field('breakdown')) && count(get_field('breakdown')) > 0)) : ?>
                        <div id="breakdown" class="mt-10">
                            <?php render_title(get_field('breakdown_section_title', 'option'), 'h3'); ?>
                            <?php if (!empty(get_field('breakdown'))) : ?>
                                <div data-accordion="property" class="text-left">
                                    <?php foreach (get_field('breakdown') as $key => $value) : ?>
                                        <div class="border-b border-solid border-smoke/20">
                                            <div class="head py-3 ease-in-out duration-500">
                                                <button type="button" class="flex items-center justify-between w-full border-y py-2 border-smoke" data-accordion-target="#accordion-body-faqs-property-<?php echo $key; ?>" aria-expanded="false" aria-controls="accordion-body-faqs-property-<?php echo $key; ?>">
                                                    <h3 class="text-lg font-normal font-sans mb-0"><?php echo $value['title']; ?></h3>
                                                    <div class="toggle-button h-8 w-8 rounded-full border border-smoke flex items-center justify-center ease-linear duration-500 delay-0">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" viewBox="0 0 24 24">
                                                            <g>
                                                                <path d="M7.41 8.58L12 13.17l4.59-4.59L18 10l-6 6-6-6 1.41-1.42z" fill="currentColor"></path>
                                                            </g>
                                                        </svg>
                                                    </div>
                                                </button>
                                            </div>
                                            <div id="accordion-body-faqs-property-<?php echo $key; ?>" aria-labelledby="accordion-body-faqs-property-<?php echo $key; ?>" class="body text-base">
                                                <?php render_content($value['content'], 'py-4 pr-12'); ?>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>

                <div class="w-full md:w-1/3 ">
                    <div class="bg-smoke p-8">
                        <?php render_title("Visit " . get_the_title(), 'h3'); ?>

                        <div class="flex flex-col">
                            <?php if (!empty(get_field('check_in_time', 'option'))) : ?>
                                <span><strong>Check-in:</strong> <?php echo get_field('check_in_time', 'option'); ?></span>
                            <?php endif; ?>
                            <?php if (!empty(get_field('check_out_time', 'option'))) : ?>
                                <span><strong>Check-out:</strong> <?php echo get_field('check_out_time', 'option'); ?></span>
                            <?php endif; ?>
                        </div>

                        <?php render_content(get_field('booking_details', 'options'), 'mt-4 text-sm'); ?>

                        <div class="mt-6">
                            <?php
                            if (!empty($button = get_field('booking_link'))) {
                                render_buttons([
                                    "buttons" => array(
                                        array(
                                            "link" => array(
                                                "url" => $button,
                                                "title" => get_field('reservation_button_label', 'option')
                                            ),
                                            "style" => "solid",
                                            "colour" => "secondary",
                                            "class" => 'w-full bg-primary font-bold',
                                        )
                                    )
                                ]);
                            }
                            if (!empty($button = get_field('contact_page', 'option'))) {
                                render_buttons([
                                    "buttons" => array(
                                        array(
                                            "link" => array(
                                                "url" => get_the_permalink($button),
                                                "title" => get_field('host_button_label', 'option')
                                            ),
                                            "style" => "keyline",
                                            "colour" => "primary",
                                            "class" => 'w-full',
                                        )
                                    ),
                                    "buttonClass" => 'w-full',
                                    "remove_class" => "mb-4"
                                ]);
                            }
                            ?>
                        </div>

                    </div>

                    <div class="mt-10">
                        <hr class="border-primary my-10 border-b-1 opacity-40">

                        <?php render_title(get_field('other_properties_label', 'option'), 'h3'); ?>
                        <?php render_content(get_field('other_properties_content', 'option'), 'h3', 'text-sm'); ?>

                        <?php
                        $args = array(
                            'posts_per_page' => 2,
                            'post_type' => 'property',
                            'post_status' => 'publish',
                            'post__not_in' => array(get_the_id())
                        );
                        $posts = new WP_Query($args);
                        if ($posts->have_posts()) {
                            while ($posts->have_posts()) {
                                $posts->the_post();
                                view('property.post-landscape', null, null, ["class" => "bg-smoke"]);
                            }
                        }
                        wp_reset_postdata();
                        ?>

                        <hr class="border-primary mb-4 border-b-1 opacity-40">
                    </div>
                </div>
            </div>

        </main>
    </div>

    <script>
        window.addEventListener('load', () => {
            const swiper = new Swiper('.swiper-property-gallery', {
                loop: true,
                draggable: true,
                slidesPerView: 1,
                spaceBetween: 0,
                grabCursor: true,
                createElements: true,
                autoplay: {
                    delay: 4000,
                    pauseOnMouseEnter: true,
                },
            });
        });
    </script>

    <?php if (!empty(get_field('google_map'))) : ?>
        <script src="https://maps.googleapis.com/maps/api/js?key=<?php echo GOOGLE_MAPS_API_KEY; ?>&callback=Function.prototype"></script>
        <script type="text/javascript">
            (function($) {

                /**
                 * initMap
                 *
                 * Renders a Google Map onto the selected jQuery element
                 *
                 * @date    22/10/19
                 * @since   5.8.6
                 *
                 * @param   jQuery $el The jQuery element.
                 * @return  object The map instance.
                 */
                function initMap($el) {

                    // Find marker elements within map.
                    var $markers = $el.find('.marker');

                    // Create gerenic map.
                    var mapArgs = {
                        zoom: $el.data('zoom') || 16,
                        mapTypeId: google.maps.MapTypeId.ROADMAP
                    };
                    var map = new google.maps.Map($el[0], mapArgs);

                    // Add markers.
                    map.markers = [];
                    $markers.each(function() {
                        initMarker($(this), map);
                    });

                    // Center map based on markers.
                    centerMap(map);

                    // Return map instance.
                    return map;
                }

                /**
                 * initMarker
                 *
                 * Creates a marker for the given jQuery element and map.
                 *
                 * @date    22/10/19
                 * @since   5.8.6
                 *
                 * @param   jQuery $el The jQuery element.
                 * @param   object The map instance.
                 * @return  object The marker instance.
                 */
                function initMarker($marker, map) {

                    // Get position from marker.
                    var lat = $marker.data('lat');
                    var lng = $marker.data('lng');
                    var latLng = {
                        lat: parseFloat(lat),
                        lng: parseFloat(lng)
                    };

                    // Create marker instance.
                    var marker = new google.maps.Marker({
                        position: latLng,
                        map: map
                    });

                    // Append to reference for later use.
                    map.markers.push(marker);

                    // If marker contains HTML, add it to an infoWindow.
                    if ($marker.html()) {

                        // Create info window.
                        var infowindow = new google.maps.InfoWindow({
                            content: $marker.html()
                        });

                        // Show info window when marker is clicked.
                        google.maps.event.addListener(marker, 'click', function() {
                            infowindow.open(map, marker);
                        });
                    }
                }

                /**
                 * centerMap
                 *
                 * Centers the map showing all markers in view.
                 *
                 * @date    22/10/19
                 * @since   5.8.6
                 *
                 * @param   object The map instance.
                 * @return  void
                 */
                function centerMap(map) {

                    // Create map boundaries from all map markers.
                    var bounds = new google.maps.LatLngBounds();
                    map.markers.forEach(function(marker) {
                        bounds.extend({
                            lat: marker.position.lat(),
                            lng: marker.position.lng()
                        });
                    });

                    // Case: Single marker.
                    if (map.markers.length == 1) {
                        map.setCenter(bounds.getCenter());

                        // Case: Multiple markers.
                    } else {
                        map.fitBounds(bounds);
                    }
                }

                // Render maps on page load.
                $(document).ready(function() {
                    $('.acf-map').each(function() {
                        var map = initMap($(this));
                    });
                });

            })(jQuery);
        </script>
    <?php endif; ?>