const _ = require("lodash");

module.exports = {
    mode: 'jit',
    content: [
        './*/*.php',
        './**/*.php',
        './resources/css/*.css',
        './resources/js/*.js',
    ],
    theme: {
        container: {
            center: true
        },
        fontFamily: {
            'sans': ['Sen', 'sans-serif'],
            'display': ['Sen', 'sans-serif'],
        },
        fontSize: {
            'xs': '.8rem',
            'sm': '.9rem',
            'base': '1rem',
            'lg': '1.2rem',
            'xl': '1.5rem',
            '2xl': '1.9rem',
            '3xl': '2.3rem',
            '4xl': '3.2rem',
            '5xl': '5rem',
            '6xl': '5rem',
            '7xl': '6rem',
        },
        extend: {
            colors: {
                primary: '#DDEF58',
                secondary: '#DDEF58',
                white: '#ffffff',
                smoke: '#EBEBEB',
                black: '#141B2F',
                transparent: 'transparent',
                inherit: 'inherit',
                debug: '#E818D8',
            },
            aspectRatio: {
                '3/5': '3 / 5',
            },
            maxWidth: {
                'edge': '1800px',
            },
            borderRadius: {
                '4xl': '7rem'
            }
        },
        screens: {
            'sm': '640px',
            'md': '768px',
            'lg': '1024px',
            'xl': '1140px',
            '2xl': '1310px',
            'header-breakpoint': '985px',
        }
    },
    safelist : [
        'alignfull',
        'text-smoke',
        'alignwide',
        'aligncenter',
        'alignnone',
        'alignright',
        'wp-block-button',
        'wp-caption',
        'wp-caption-text',
        'aspect-video',
        'bg-primary',
        'bg-secondary',
        'bg-black',
        'bg-white',
        'bg-smoke',
        'bg-transparent',
        'text-primary',
        'text-secondary',
        'text-black',
        'text-white',
        'text-sans', 'text-display',
        'normal-case', 'capitalize', 'uppercase'
    ],
    plugins: [
        require('tailwindcss-animated')
    ]
};
