<?php
/** Template Name: Style Guide */

// Include the header.
get_header();

?>

<section class="container mx-auto py-20">

    <h1 class="text-center text-debug">Basic Styling</h1>
    <div class="mb-20">
        <div class="py-5 border-t border-b border-debug mb-5">
            <p class="text-debug">Titles</p>

            <h1>This is a H1 element</h1>
            <h2>This is a H2 element</h2>
            <h3>This is a H3 element</h3>
            <h4>This is a H4 element</h4>
            <h5>This is a H5 element</h5>

        </div>
        <div class="py-5 border-t border-b border-debug mb-5">
            <p class="text-debug">Lists</p>

            <ul>
                <li>This is a li element</li>
                <li>This is a li element</li>
                <li>This is a li element</li>
            </ul>

            <ol>
                <li>This is a li element</li>
                <li>This is a li element with a <a href="#" title="Take me to the moon baby!">'a' element</a></li>
                <li>This is a li element</li>
            </ol>

            <ul class="list-checks">
                <li>This is a check li element</li>
                <li>This is a check li element</li>
                <li>This is a check li element</li>
            </ul>

            <ul class="list-none p-0 m-0">
                <li>This is a check li element</li>
                <li>This is a check li element</li>
                <li>This is a check li element</li>
            </ul>

        </div>


        <div class="py-5 border-t border-b border-debug mb-5"> 
            <p class="text-debug">Titles - Small</p>
            <?php 
            render_buttons([
                    "buttons" => array(
                        array(
                            "link" => array(
                                "url" => '#',
                                "title" => "Read more"
                            ),
                            "style" => "solid",
                            "colour" => "primary"
                        ),
                        array(
                            "link" => array(
                                "url" => '#',
                                "title" => "Read more"
                            ),
                            "style" => "solid",
                            "colour" => "secondary"
                        ),
                        array(
                            "link" => array(
                                "url" => '#',
                                "title" => "Read more"
                            ),
                            "style" => "solid",
                            "colour" => "tertiary"
                        ),
                        array(
                            "link" => array(
                                "url" => '#',
                                "title" => "Read more"
                            ),
                            "style" => "solid",
                            "colour" => "white"
                        ),
                        array(
                            "link" => array(
                                "url" => '#',
                                "title" => "Read more"
                            ),
                            "style" => "solid",
                            "colour" => "black"
                        ),
                        array(
                            "link" => array(
                                "url" => '#',
                                "title" => "Read more"
                            ),
                            "style" => "keyline",
                            "colour" => "primary"
                        ),
                        array(
                            "link" => array(
                                "url" => '#',
                                "title" => "Read more"
                            ),
                            "style" => "keyline",
                            "colour" => "secondary"
                        ),
                        array(
                            "link" => array(
                                "url" => '#',
                                "title" => "Read more"
                            ),
                            "style" => "keyline",
                            "colour" => "tertiary"
                        ),
                        array(
                            "link" => array(
                                "url" => '#',
                                "title" => "Read more"
                            ),
                            "style" => "keyline",
                            "colour" => "white"
                        ),
                        array(
                            "link" => array(
                                "url" => '#',
                                "title" => "Read more"
                            ),
                            "style" => "keyline",
                            "colour" => "black"
                        ),
                    ),
                    "size" => "small",
                    "wrapClass" => "",
                ]);
            ?>
        </div>
        <div class="py-5 border-t border-b border-debug mb-5"> 
            <p class="text-debug">Titles - Standard</p>
            <?php 
            render_buttons([
                    "buttons" => array(
                        array(
                            "link" => array(
                                "url" => '#',
                                "title" => "Read more"
                            ),
                            "style" => "solid",
                            "colour" => "primary"
                        ),
                        array(
                            "link" => array(
                                "url" => '#',
                                "title" => "Read more"
                            ),
                            "style" => "solid",
                            "colour" => "secondary"
                        ),
                        array(
                            "link" => array(
                                "url" => '#',
                                "title" => "Read more"
                            ),
                            "style" => "solid",
                            "colour" => "tertiary"
                        ),
                        array(
                            "link" => array(
                                "url" => '#',
                                "title" => "Read more"
                            ),
                            "style" => "solid",
                            "colour" => "white"
                        ),
                        array(
                            "link" => array(
                                "url" => '#',
                                "title" => "Read more"
                            ),
                            "style" => "solid",
                            "colour" => "black"
                        ),
                        array(
                            "link" => array(
                                "url" => '#',
                                "title" => "Read more"
                            ),
                            "style" => "keyline",
                            "colour" => "primary"
                        ),
                        array(
                            "link" => array(
                                "url" => '#',
                                "title" => "Read more"
                            ),
                            "style" => "keyline",
                            "colour" => "secondary"
                        ),
                        array(
                            "link" => array(
                                "url" => '#',
                                "title" => "Read more"
                            ),
                            "style" => "keyline",
                            "colour" => "tertiary"
                        ),
                        array(
                            "link" => array(
                                "url" => '#',
                                "title" => "Read more"
                            ),
                            "style" => "keyline",
                            "colour" => "white"
                        ),
                        array(
                            "link" => array(
                                "url" => '#',
                                "title" => "Read more"
                            ),
                            "style" => "keyline",
                            "colour" => "black"
                        ),
                    ),
                    "wrapClass" => "",
                ]);
            ?>
        </div>

        <div class="py-5 border-t border-b border-debug mb-5"> 
            <p class="text-debug">Social Icons</p>
            <?php render_social_icons('list-none flex ml-0 p-0', 'border border-solid border-primary w-8 h-8 flex items-center justify-center mr-4 rounded-lg fill-primary hover:bg-primary hover:fill-white ease-in-out duration-500', 'w-4 h-4'); ?>
        </div>

        <div class="py-5 border-t border-b border-debug mb-5 bg-secondary"> 
            <p class="text-debug">Footer Menu</p>
            <footer>
                <?php 
                    wp_nav_menu(array(
                        'theme_location' => 'footer-one',
                        'container' => 'div',
                        'container_class' => 'footer-menu'
                    ));
                ?>
            </footer>
        </div>

    </div>

    <h1 class="text-center text-debug">WYSIWYG Styling</h1>
    <div class="wysiwyg">

        <div class="py-5 border-t border-b border-debug mb-5">
            <p class="text-debug">Titles</p>

            <h1>This is a H1 element</h1>
            <h2>This is a H2 element</h2>
            <h3>This is a H3 element</h3>
            <h4>This is a H4 element</h4>
            <h5>This is a H5 element</h5>

        </div>
        
        <div class="py-5 border-t border-b border-debug mb-5">
            <p class="text-debug">Content</p>

            <p>A parturient auctor faucibus morbi sociis bibendum nec ligula scelerisque a nisl tellus adipiscing aliquet habitasse proin suspendisse eu. Viverra habitant a vitae quam nisi leo adipiscing scelerisque neque tristique sed a consectetur viverra lacinia sagittis faucibus id mi ullamcorper condimentum venenatis per adipiscing adipiscing.</p>

        </div>

        <div class="py-5 border-t border-b border-debug mb-5">
            <p class="text-debug">Example Document</p>

            <?php echo render_title('This is a H2 element', 'h2'); ?>
            <p>A parturient auctor faucibus morbi <strong> but can I please be bold?</strong>. Bibendum nec ligula scelerisque a nisl tellus adipiscing aliquet habitasse proin suspendisse eu. <i>We're getting lanted here – Viverra habitant a vitae quam nisi leo adipiscing scelerisque neque tristique</i> sed a consectetur viverra lacinia sagittis faucibus id mi ullamcorper condimentum venenatis per adipiscing adipiscing.</p>
            <p>A parturient auctor faucibus morbi sociis bibendum nec ligula scelerisque a nisl tellus adipiscing aliquet habitasse proin suspendisse eu. Viverra habitant a vitae quam nisi leo adipiscing scelerisque neque tristique sed a consectetur viverra lacinia sagittis faucibus id mi ullamcorper condimentum venenatis per adipiscing adipiscing.</p>
            <?php echo render_title('This is a H3 element', 'h3'); ?>
            <p>A parturient auctor faucibus morbi sociis bibendum nec ligula scelerisque a nisl tellus adipiscing aliquet habitasse proin suspendisse eu. Viverra habitant a vitae quam nisi leo adipiscing scelerisque neque tristique sed a consectetur viverra lacinia sagittis faucibus id mi ullamcorper condimentum venenatis per adipiscing adipiscing.</p>
            <ul>
                <li>This is a li element</li>
                <li>This is a li element</li>
                <li>This is a li element</li>
            </ul>
            <p>A parturient auctor faucibus morbi sociis bibendum nec ligula scelerisque a nisl tellus adipiscing aliquet habitasse proin suspendisse eu. Viverra habitant a vitae quam nisi leo adipiscing scelerisque neque tristique sed a consectetur viverra lacinia sagittis faucibus id mi ullamcorper condimentum venenatis per adipiscing adipiscing.</p>
            <?php echo render_title('This is a H4 element', 'h4'); ?>
            <ol>
                <li>This is a li element</li>
                <li>This is a li element with a <a href="#" title="Take me to the moon baby!">'a' element</a></li>
                <li>This is a li element</li>
            </ol>
            <p>A parturient auctor faucibus morbi sociis bibendum nec ligula scelerisque a nisl tellus adipiscing aliquet habitasse proin suspendisse eu. Viverra habitant a vitae quam nisi leo adipiscing scelerisque neque tristique sed a consectetur viverra lacinia sagittis faucibus id mi ullamcorper condimentum venenatis per adipiscing adipiscing.</p>
            <figure>
                <img src="//via.placeholder.com/500x60" alt="You should ensure you include an alt!">
                <figcaption>This is a caption for this amazing image.</figcaption>
            </figure>
            <p>A parturient auctor faucibus morbi sociis bibendum nec ligula scelerisque a nisl tellus adipiscing aliquet habitasse proin suspendisse eu. Viverra habitant a vitae quam nisi leo adipiscing scelerisque neque tristique sed a consectetur viverra lacinia sagittis faucibus id mi ullamcorper condimentum venenatis per adipiscing adipiscing.</p>
            <ul>
                <li>This is a li element</li>
                <li>This is a li element
                    <ul>
                        <li>This is a nested li element</li>
                    </ul>
                </li>
                <li><p>This is a 'p' element inside a 'li' element</p></li>
            </ul>
            <p>A parturient auctor faucibus morbi sociis bibendum nec ligula scelerisque a nisl tellus adipiscing aliquet habitasse proin suspendisse eu. Viverra habitant a vitae quam nisi leo adipiscing scelerisque neque tristique sed a consectetur viverra lacinia sagittis faucibus id mi ullamcorper condimentum venenatis per adipiscing adipiscing.</p>
            <figure>
                <blockquote>
                    <p>Tis better to have loved and lost than never to have loved at all.</p>
                    <figcaption>
                        <cite>Alfred Lord Tennyson</cite>
                    </figcaption>
                </blockquote>
            </figure>
            <p>A parturient auctor faucibus morbi sociis bibendum nec ligula scelerisque a nisl tellus adipiscing aliquet habitasse proin suspendisse eu. Viverra habitant a vitae quam nisi leo adipiscing scelerisque neque tristique sed a consectetur viverra lacinia sagittis faucibus id mi ullamcorper condimentum venenatis per adipiscing adipiscing.</p>
            <hr>
            <p>A parturient auctor faucibus morbi sociis bibendum nec ligula scelerisque a nisl tellus adipiscing aliquet habitasse proin suspendisse eu. Viverra habitant a vitae quam nisi leo adipiscing scelerisque neque tristique sed a consectetur viverra lacinia sagittis faucibus id mi ullamcorper condimentum venenatis per adipiscing adipiscing.</p>
        </div>

    </div>

</section>


<?php

// Include the footer.
get_footer();

?>