<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              helloevery1.com
 * @since             1.0.0
 * @package           Every1_Faqs
 *
 * @wordpress-plugin
 * Plugin Name:       Every1 Faqs
 * Plugin URI:        helloevery1.com
 * Description:       Every1 Faqs
 * Version:           1.0.0
 * Author:            Stuart A McNair
 * Author URI:        helloevery1.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       every1-documents
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'EVERY1_FAQS_VERSION', '1.0.0' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-every1-documents-activator.php
 */
function activate_every1_faqs() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-every1-faqs-activator.php';
	Every1_Faqs_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-every1-documents-deactivator.php
 */
function deactivate_every1_faqs() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-every1-faqs-deactivator.php';
	Every1_Faqs_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_every1_faqs' );
register_deactivation_hook( __FILE__, 'deactivate_every1_faqs' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-every1-faqs.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_every1_faqs() {

	$plugin = new Every1_Faqs();
	$plugin->run();

}
run_every1_faqs();
