<?php

class Every1_Faqs_Post_Type
{
    public function __construct()
    {
        add_action('init', [$this,'create_post_type'], 0);
        add_action('init', [$this,'create_taxonomies']);
        add_filter('post_type_link', [$this, 'wpa_faq_permalinks'], 1, 2);
    }

    public function create_post_type()
    {
        $labels = [
            'name'               => 'Faq',
            'singular_name'      => 'Faq',
            'menu_name'          => 'Faq',
            'name_admin_bar'     => 'Faq',
            'add_new'            => 'Add New',
            'add_new_item'       => 'Add New Faq',
            'new_item'           => 'New Faq',
            'edit_item'          => 'Edit Faq',
            'view_item'          => 'View Faq',
            'all_items'          => 'All Faqs',
            'search_items'       => 'Search Faqs',
            'parent_item_colon'  => 'Parent Faq',
            'not_found'          => 'No Faqs Found',
            'not_found_in_trash' => 'No Faqs Found in Trash'
        ];

        $args = [
            "label" => __("Faq", ""),
            "labels" => $labels,
            "description" => "",
            "public" => true,
            "publicly_queryable" => true,
            "show_ui" => true,
            "show_in_rest" => false,
            "rest_base" => "",
            "show_in_menu" => true,
            "exclude_from_search" => false,
            "capability_type" => "post",
            "map_meta_cap" => true,
            "hierarchical" => false,
            'rewrite' => ['slug' => 'faq'],
            'has_archive' => false,
            "query_var" => true,
            "menu_position" => 20,
            "supports" => [ "title", "editor", "thumbnail", "custom-fields" ],
        ];

        register_post_type('faq', $args);
        //flush_rewrite_rules();
    }


    public function create_taxonomies()
    {
        // Add new taxonomy, make it hierarchical (like categories)
        $labels = [
            'name'              => 'FAQ Categories',
            'singular_name'     => 'Category',
            'search_items'      => 'Search Categories',
            'all_items'         => 'All Categories',
            'parent_item'       => 'Parent Category',
            'parent_item_colon' => 'Parent Category:',
            'edit_item'         => 'Edit Category',
            'update_item'       => 'Update Category',
            'add_new_item'      => 'Add New Category',
            'new_item_name'     => 'New Category Name',
            'menu_name'         => 'Categories',
        ];

        $args = [
            'hierarchical'      => true,
            'labels'            => $labels,
            'public'            => true,
            'show_ui'           => true,
            'show_admin_column' => true,
            'query_var'         => true,
            'rewrite'			=> ['slug' => 'faqs', 'with_front' => false]

        ];

        register_taxonomy('faq_category', ['faq'], $args);
    }

    public function wpa_faq_permalinks($post_link, $post)
    {
        if (is_object($post) && $post->post_type == 'faq') {
            $terms = wp_get_object_terms($post->ID, 'faq_category');
            if ($terms) {
                return str_replace('%faq_category%', $terms[0]->slug, $post_link);
            }
        }
        return $post_link;
        return str_replace('%faq_category%', 'faq_category', $post_link);
    }


}

new Every1_Faqs_Post_Type();
