<?php
/**
 * --------------------------------------------------------------------------------------------------
 * CLASS MAGIC AUTOLOADER
 * This included PHP file allows all classes in the 'blackhole' namespace to be loaded
 * automaticly when requested. 
 * 
 * @package sixon
 * @author Joe Curran
 * @version 0.0.001
 * @date 4 Jan 2023
 * 
 * --------------------------------------------------------------------------------------------------
 */
namespace sixon;

if (!function_exists('sixon\autoload')) {
    function autoload($cls) {

        $cls = ltrim($cls, '\\');
        
        if(strpos($cls, __NAMESPACE__) !== 0)
            return;
        
        $cls = str_replace(__NAMESPACE__, '', $cls);
        
        $path = plugin_dir_path(__FILE__) . substr(str_replace('\\', DIRECTORY_SEPARATOR, $cls), 1) . '.php';
        
        if (file_exists($path))
            require_once($path);
    }
    spl_autoload_register(__NAMESPACE__ . '\\autoload');
}

// Run the plugin class
(new Sixon);
