<?php
/**
 * The template for author

 *
 * @package  every1base
 * @subpackage  Timber
 * @since    Timber 0.1
 */
$context = Timber::get_context();

if(is_author()){
    $context['page'] = 'author';
}

$author_id = get_the_author_meta('ID');
$user_bio_intro = get_field('user_bio_intro', 'user_'. $author_id );
$user_bio = get_field('user_bio', 'user_'. $author_id );

$context['userpic'] =   get_avatar( get_the_author_meta('ID'), 100 ); 
$context['user_bio_intro'] =  $user_bio_intro;
$context['bio_full'] =  $user_bio;


$post = new TimberPost();
$context['post'] = $post;

$blogs = array (
    'order'     => 'DESC',
    'orderby'   => 'date',
    'post_type' => 'post',
    'post_status' => 'publish',
    'author' => $author_id,
    'posts_per_page' => 9,
    'suppress_filters' => 0,
    'paged' => $paged
);

$context['posts'] = new Timber\PostQuery($blogs);

Timber::render([ 'pages/page-author.twig' ], $context);