<?php
/**
 * every1base_scripts-wp functions and definitions.
 *
 * @see https://developer.wordpress.org/themes/basics/theme-functions/
 */

namespace EVERY1BASE;

use Timber;
use TimberMenu;
use TimberSite;


define('THEME_VERSION', '1.0');

//Remove Gutenberg editor
// disable for posts
add_filter('use_block_editor_for_post', '__return_false', 10);

// disable for post types
add_filter('use_block_editor_for_post_type', '__return_false', 10);

if (getenv('WP_ENV') == 'development') {
    error_reporting(1);
} else {
    error_reporting(0);
}

//$timber = new Timber\Timber();

if (!class_exists('Timber')) {
    add_action('admin_notices', function () {
        echo '<div class="error"><p>Timber not activated. Make sure you activate the plugin in <a href="'.esc_url(admin_url('plugins.php#timber')).'">'.esc_url(admin_url('plugins.php')).'</a></p></div>';
    });

    add_filter('template_include', function ($template) {
        return get_stylesheet_directory().'/static/no-timber.html';
    });

    return;
}

Timber::$dirname = ['templates', 'views', 'dist/images/base-wp-icons-icons'];

class Every1Base extends TimberSite
{
    public function __construct()
    {
        add_theme_support('post-thumbnails');
        add_theme_support('menus');
        add_theme_support('html5', ['comment-list', 'comment-form', 'search-form', 'gallery', 'caption']);

        // Yoast fix (https://kb.yoast.com/kb/the-seo-title-output-for-the-plugin-doesnt-work-as-expected/)
        add_theme_support('title-tag');

        add_filter('timber_context', [$this, 'add_to_context']);
        add_filter('get_twig', [$this, 'add_to_twig']);
        add_action('init', [$this, 'register_post_types']);
        add_action('init', [$this, 'register_taxonomies']);
        add_action('wp_enqueue_scripts', [$this, 'every1base_scripts']);
        add_action('init', [$this, 'every1base_add_editor_styles']);

        add_action('after_setup_theme', [$this, 'every1_custom_add_image_sizes']);

        add_filter('image_size_names_choose', [$this, 'every1_custom_add_image_size_names']);

        add_filter('wp_mail_content_type', [$this, 'set_mail_content_type']);

        add_action('login_enqueue_scripts', [$this, 'every1base_login_styles']);
        add_action('admin_enqueue_scripts', [$this, 'every1base_admin_styles']);

        parent::__construct();
    }

    public function every1_custom_add_image_sizes()
    {
        add_image_size('postSmall', 368, 208, true); //Post Thumbnail
        add_image_size('homepageMobile', 519, 314, true); //Homepage hero module mobile image
        add_image_size('postHeader', 1600, 540, true); //Post Header Image
        add_image_size('postHeaderMobile', 800, 501, true); //Post Header Image
    }

    public function every1_custom_add_image_size_names($sizes)
    {
        return array_merge($sizes, [
            'postSmall' => __('Post Small'),
            'postHeader' => __('Post Header'),
            'postHeaderMobile' => __('Post Header Mobile'),
        ]);
    }

    /*
        public function remove_admin_menus()
        {
            if (!current_user_can('manage_sites')) {
                remove_menu_page('edit-comments.php');
                remove_menu_page('tools.php');
                remove_menu_page('wp-acf-vc-bridge-settings');
                remove_menu_page('vc-welcome');
                remove_menu_page('edit.php?post_type=vc_snippet');
            }
        }
    */

    public function register_post_types()
    {
        //this is where you can register custom post types
    }

    public function register_taxonomies()
    {
        //this is where you can register custom taxonomies
    }

    public function add_to_context($context)
    {
        // $context['foo'] = 'bar';
        // $context['stuff'] = 'I am a value set in your functions.php file';
        // $context['notes'] = 'These values are available everytime you call Timber::get_context();';

        //Add Theme version to context - set at top of page
        $context['theme_version'] = THEME_VERSION;

        // Add site menus to context
        $context['main_menu'] = new TimberMenu(2);
        $context['footer_menu_one'] = new TimberMenu(9);
        $context['footer_menu_two'] = new TimberMenu(3);
        $context['footer_menu_three'] = new TimberMenu(4);
        $context['options'] = get_fields('option');

        $context['site'] = $this;

        $postCategories = [
            'taxonomy' => 'category',
            'orderby' => 'name',
            'order' => 'ASC',
            'parent' => 0,
            'hide_empty' => true,
        ];
        $context['post_categories'] = Timber::get_terms($postCategories);

        $related_cat_id = wp_get_post_categories($post->ID);
        $relatedArticles = [
            'order' => 'DESC',
            'orderby' => 'date',
            'post_type' => 'post',
            'post_status' => 'publish',
            'posts_per_page' => 3,
            'category' => $related_cat_id,
            'post__not_in' => [$post->ID],
        ];
        $context['related_articles'] = new Timber\PostQuery($relatedArticles);

        return $context;
    }

    public function myfoo($text)
    {
        $text .= ' bar!';

        return $text;
    }

    public function add_to_twig($twig)
    {
        /* this is where you can add your own functions to twig */
        $twig->addExtension(new \Twig_Extension_StringLoader());
        $twig->addFilter('myfoo', new \Twig_SimpleFilter('myfoo', [$this, 'myfoo']));

        return $twig;
    }

    public function every1base_scripts()
    {
        wp_enqueue_style('every1base-style', get_template_directory_uri().'/dist/styles/style.min.css', [], filemtime(get_template_directory().'/dist/styles/style.min.css'));

       
            wp_enqueue_script('every1base-jscustom', get_template_directory_uri().'/dist/scripts/scripts.custom.min.js', ['jquery'], filemtime(get_template_directory().'/dist/scripts/scripts.custom.min.js'), true);

            wp_enqueue_script('every1base-jscomponents', get_template_directory_uri().'/dist/scripts/scripts.components.min.js', ['jquery'], filemtime(get_template_directory().'/dist/scripts/scripts.components.min.js'), true);

            wp_enqueue_script('every1base-jslib', get_template_directory_uri().'/dist/scripts/scripts.lib.min.js', ['jquery'], filemtime(get_template_directory().'/dist/scripts/scripts.custom.min.js'), true);
      
          
    }

    public function every1base_login_styles()
    {
        wp_enqueue_style('custom-login', get_template_directory_uri().'/dist/admin-styles/login.min.css', false, filemtime(get_template_directory().'/dist/admin-styles/login.min.css'));
    }

    public function every1base_admin_styles()
    {
        wp_register_style('custom_wp_admin_css', get_template_directory_uri().'/dist/admin-styles/admin.min.css', false, filemtime(get_template_directory().'/dist/admin-styles/admin.min.css'));
        wp_enqueue_style('custom_wp_admin_css');
    }

    public function every1base_add_editor_styles()
    {
        add_editor_style(get_template_directory_uri().'/dist/admin-styles/custom-editor-style.min.css');
    }

    public function set_mail_content_type()
    {
        return 'text/html';
    }
}

new every1base();

/**
 * Shortcodes.
 */
//require_once(__DIR__ . '/includes/shortcodes.php');

require get_template_directory().'/vc-functions.php';
/**
 * Load ACF Configs.
 */
require_once __DIR__.'/includes/acf/theme-settings.php';
/**
 * Custom Functions.
 */
require_once __DIR__.'/includes/custom-functions.php';

// Boot page builder
require_once __DIR__.'/page-builder/boot.php';

// FLUSH REWRITE RULES FOR CUSTOM POST TYPES
// Only enable this when absolutely nessasary
// https://codex.wordpress.org/Function_Reference/flush_rewrite_rules
//flush_rewrite_rules();
