<?php

// Remove P tags from images
function filter_ptags_on_images($content)
{
    return preg_replace('/<p>\s*(<a .*>)?\s*(<img .* \/>)\s*(<\/a>)?\s*<\/p>/iU', '\1\2\3', $content);
}

add_filter('the_content', 'filter_ptags_on_images');

// add slug to body classes
function add_slug_body_class($classes)
{
    global $post;
    if (isset($post)) {
        $classes[] = $post->post_type.'-'.$post->post_name;
    }

    return $classes;
}
add_filter('body_class', 'add_slug_body_class');

// Move Yoast to bottom
function yoasttobottom()
{
    return 'low';
}
add_filter('wpseo_metabox_prio', 'yoasttobottom');

//Anchor to Gform for confirmation
add_filter('gform_confirmation_anchor', '__return_true');

//Change GF error message
add_filter('gform_validation_message', 'change_message', 10, 2);
function change_message($message, $form)
{
    return "<div class='validation_error'>Sorry, we don't seem to have all we need here. Please check below to see what's not quite right.</div>";
}

//Changeing GF spinner
add_filter('gform_ajax_spinner_url', 'spinner_url', 10, 2);
function spinner_url($image_src, $form)
{
    return  get_bloginfo('template_directory').'/dist/images/ajax-loader.gif';
}

//Prevent Uncaught ReferenceError: jQuery is not defined error due to JQuery https://hereswhatidid.com/2013/01/move-gravity-forms-jquery-calls-to-footer/
add_filter('gform_init_scripts_footer', 'init_scripts');
    function init_scripts()
    {
        return true;
    }
//UK phone format
add_filter('gform_phone_formats', 'uk_phone_format');
function uk_phone_format($phone_formats)
{
    $phone_formats['uk'] = [
        'label' => 'UK',
        'mask' => false,
        'regex' => '/^(((\+44\s?\d{4}|\(?0\d{4}\)?)\s?\d{3}\s?\d{3})|((\+44\s?\d{3}|\(?0\d{3}\)?)\s?\d{3}\s?\d{4})|((\+44\s?\d{2}|\(?0\d{2}\)?)\s?\d{4}\s?\d{4}))(\s?\#(\d{4}|\d{3}))?$/',
        'instruction' => false,
    ];

    return $phone_formats;
}

// Insert 'styleselect' into the $buttons array
function my_mce_buttons_2($buttons)
{
    array_unshift($buttons, 'styleselect');

    return $buttons;
}

// For adding wysiwig classes
// Use 'mce_buttons' for button row #1, mce_buttons_3' for button row #3

add_filter('mce_buttons_2', 'my_mce_buttons_2');

function my_mce_before_init_insert_formats($init_array)
{
    $style_formats = [
          [
             'title' => 'Sub Title', // Title to show in dropdown
             'selector' => 'p', // Element to add class to
             'classes' => 'c-content__sub-title', // CSS class to add
         ],
     ];
    $init_array['style_formats'] = json_encode($style_formats);

    return $init_array;
}

add_filter('tiny_mce_before_init', 'my_mce_before_init_insert_formats');

//ACF Options

if (function_exists('acf_add_options_page')) {
    acf_add_options_page([
        'page_title' => 'Theme options',
        'menu_title' => 'Theme options',
        'menu_slug' => 'theme-options',
        'parent_slug' => '',
        'position' => false,
        'icon_url' => false,
        'redirect' => true,
    ]);
}
//VC Nested modules
//Image Slider
if (class_exists('WPBakeryShortCodesContainer')) {
    class WPBakeryShortCode_vc_every1_image_slider extends WPBakeryShortCodesContainer
    {
    }
    class WPBakeryShortCode_vc_every1_content_carousel extends WPBakeryShortCodesContainer
    {
    }
    class WPBakeryShortCode_vc_every1_image_grid extends WPBakeryShortCodesContainer
    {
    }
    class WPBakeryShortCode_vc_every1_faq_custom_list extends WPBakeryShortCodesContainer
    {
    }
}
if (class_exists('WPBakeryShortCode')) {
    class WPBakeryShortCode_vc_every1_image_slider_child extends WPBakeryShortCode
    {
    }

    class WPBakeryShortCode_vc_every1_content_carousel_child extends WPBakeryShortCode
    {
    }
    class WPBakeryShortCode_vc_every1_image_grid_child extends WPBakeryShortCode
    {
    }
    class WPBakeryShortCode_vc_phoenix_faq_custom_list_child extends WPBakeryShortCode
    {
    }
}
