<?php

namespace every1base\PageBuilder;

/**
 * Page Builder / Visual Composer.
 */
class PageBuilder
{
    // Add new elements here:
    protected $elements = [
        'button',
        'spacer',
        // 'image-slider',
        'video-banner',
        'content-carousel',
        'image-grid',
        'faq-custom-list',
        'cta-strip',
        'article-links',
    ];

    public function __construct()
    {
        add_action('vc_before_init', [$this, 'set_directory']);
        add_action('vc_before_init', [$this, 'init_elements']);
        add_filter('vc_before_init', [$this, 'remove_elements']);
    }

    public function elements_dir()
    {
        return get_template_directory().'/page-builder/elements';
    }

    public function set_directory()
    {
        if (function_exists('vc_set_shortcodes_templates_dir')) {
            vc_set_shortcodes_templates_dir($this->elements_dir());
        }
    }

    public function init_elements()
    {
        foreach ($this->elements as $element) {
            require_once $this->elements_dir().'/'.$element.'.php';
        }
    }

    public function remove_elements()
    {
        // 		vc_remove_element('vc_wp_text');
        vc_remove_element('vc_zigzag');
        vc_remove_element('vc_message');
        vc_remove_element('vc_hoverbox');
        vc_remove_element('vc_facebook');
        vc_remove_element('vc_tweetmeme');
        vc_remove_element('vc_googleplus');
        vc_remove_element('vc_pinterest');
        vc_remove_element('vc_tta_tour');
        vc_remove_element('vc_toggle');
        //vc_remove_element('vc_tta_accordion');
        vc_remove_element('vc_tta_pageable');
        vc_remove_element('vc_progress_bar');
        vc_remove_element('vc_pie');
        vc_remove_element('vc_round_chart');
        vc_remove_element('vc_line_chart');
        vc_remove_element('vc_flickr');
        vc_remove_element('vc_basic_grid');
        vc_remove_element('vc_media_grid');
        vc_remove_element('vc_masonry_grid');
        vc_remove_element('vc_masonry_media_grid');
        vc_remove_element('vc_acf');
        vc_remove_element('vc_wp_meta');
        vc_remove_element('vc_wp_recentcomments');
        vc_remove_element('vc_wp_calendar');
        vc_remove_element('vc_wp_tagcloud');
        vc_remove_element('vc_wp_text');
        vc_remove_element('vc_wp_categories');
        vc_remove_element('vc_wp_archives');
        vc_remove_element('vc_tabs');
        vc_remove_element('vc_tta_tabs');
        vc_remove_element('vc_tour');
        vc_remove_element('vc_accordion');
        vc_remove_element('vc_widget_sidebar');
        vc_remove_element('vc_posts_slider');
        vc_remove_element('vc_custom_heading');
        vc_remove_element('vc_btn');
        vc_remove_element('vc_cta');
        vc_remove_element('vc_gmaps');
        vc_remove_element('vc_icon');
        vc_remove_element('vc_gallery');
        vc_remove_element('vc_images_carousel');
        vc_remove_element('vc_wp_search');
        vc_remove_element('vc_gutenberg');
        vc_remove_element('vc_wp_custommenu');
        vc_remove_element('vc_wp_posts');
        vc_remove_element('vc_wp_pages');
        vc_remove_element('vc_wp_rss');
    }
}

new PageBuilder();
