<?php

namespace every1base\PageBuilder\Elements;

use Timber;
use \WPBakeryShortCode;
use TimberImage;


// Element Class
class ImageSliderElement extends WPBakeryShortCode
{

    // Element Init
    public function __construct()
    {
        add_action('init', [ $this, 'mapping' ],12);
        add_shortcode('vc_every1_image_slider', [$this, 'html']);
        add_shortcode('vc_every1_image_slider_child', [$this, 'html_child']);
    }

    // Element Mapping
    public function mapping()
    {

        // Stop all if VC is not enabled
        if (!defined('WPB_VC_VERSION')) {
            return;
        }

        // Map the block with vc_map()
        vc_map(
            [
                'name' => __('Image Slider', 'text-domain'),
                'base' => 'vc_every1_image_slider',
                'category' => __('Custom Elements', 'text-domain'),
                'description' => __('Images Slider - (Stretch no padding)', 'text-domain'),
                'icon' => get_template_directory_uri().'/dist/images/vc_icons/every1-vc-slider.png',
                'as_parent' => ['only' => 'vc_every1_image_slider_child',],
                'content_element' => true,
                'show_settings_on_create' => false,
                'is_container' => true,
                'js_view' => 'VcColumnView',

            ]
        );

        vc_map(
            [
                'name' => __('Slider Image', 'text-domain'),
                'base' => 'vc_every1_image_slider_child',
                'description' => __('Slider Image', 'text-domain'),
                'category' => __('Custom Elements', 'text-domain'),
                'icon' => get_template_directory_uri().'/dist/images/vc_icons/every1-vc-slider.png',
                'as_child' => ['only' => 'vc_every1_image_slider'],
                'content_element' => true,
                'show_settings_on_create' => true,
                'params' => [
                    [
                        'type' => 'textfield',
                        'heading' => __('Title', 'text-domain'),
                        'param_name' => 'title',
                        'std' => '',
                        'description' => __('Title', 'text-domain'),
                        'class' => '',
                        'admin_label' => true,
                    ],
                    [
                        'type' => 'textarea',
                        'heading' => __('Description', 'text-domain'),
                        'param_name' => 'description',
                        'std' => '',
                        'description' => __('Description - shown on hover', 'text-domain'),
                        'class' => '',
                        'admin_label' => true,
                    ],
                    [
                        'type' => 'attach_image',
                        'holder' => 'img',
                        'heading' => __('Image', 'text-domain'),
                        'param_name' => 'image',
                        'admin_label' => false,
                        'weight' => 0,
                    ],   
                    [
                        'type' => 'vc_link',
                        'heading' => __('Link', 'inivos'),
                        'param_name' => 'page_link',
                        'admin_label' => false,
                        'weight' => 0,
                    ],
                ],
            ]
        );
    }

    public function html($atts, $content = null)
    {
        $this->context['atts'] = $atts;
        $this->context['content'] = $content;
        return Timber::fetch('page-builder/image-slider.twig', $this->context);
    }

    public function html_child($atts, $content = null)
    {
        $this->context = Timber::get_context();
        $this->context['atts'] = $atts;
        $this->context['content'] = $content;
        $this->context['image'] = new TimberImage($atts['image']);
        if (isset($atts['page_link'])) {
            $this->context['atts']['page_link'] = vc_build_link($atts['page_link']);
        }
        return Timber::fetch('page-builder/child/image-slider-child.twig', $this->context);
    }
} // End Element Class


// Element Class Init
new ImageSliderElement();
