<?php

namespace every1base\PageBuilder\Elements;

use Timber;
use TimberTerm;
use WPBakeryShortCode;

/*
Element Description: Article Links
*/

// Element Class
class ArticleLinksElement extends WPBakeryShortCode
{
    protected $context;

    // Element Init
    public function __construct()
    {
        add_action('init', [$this, 'mapping'], 12);
        add_shortcode('vc_every1_article_links', [$this, 'html']);
    }

    // Element Mapping
    public function mapping()
    {
        // Stop all if VC is not enabled
        if (!defined('WPB_VC_VERSION')) {
            return;
        }

        // Map the block with vc_map()
        vc_map(
            [
                'name' => __('Article Links', 'text-domain'),
                'base' => 'vc_every1_article_links',
                'description' => __('Article Links, place at the bottom of the page', 'text-domain'),
                'category' => __('Custom Elements', 'text-domain'),
                'icon' => get_template_directory_uri().'/dist/images/pb-icon--trax.png',
                'params' => [
                    [
                        'type' => 'dropdown',
                        'heading' => __('Select Article Category', 'text-domain'),
                        'param_name' => 'category_id',
                        'value' => $this->getSelectableArticleCategories(),
                    ],
                ],
            ]
        );
    }

    public function getSelectableArticleCategories()
    {
        $selectableCategories = [
            [
                'category_id' => '',
                'category_name' => '- All Articles -',
            ],
        ];

        $articleCategories = Timber::get_terms('category');

        if (is_wp_error($articleCategories)) {
            return $selectableCategories;
        }

        foreach ($articleCategories as $category) {
            $selectableCategories[] = [
                'category_id' => $category->id,
                'category_name' => $category->title,
            ];
        }

        return $selectableCategories;
    }

    public function getArticles($category_id)
    {
        $articles = Timber::get_posts([
            'post_type' => 'post',
            'meta_query' => [
                [
                    'cat' => $category_id,
                ],
            ],
            'orderby' => 'meta_value_num',
            'order' => 'ASC',
            'posts_per_page' => '3',
            ]);

        return $articles;
    }

    public function html($atts, $content = null)
    {
        $this->context = Timber::get_context();
        $this->context['atts'] = $atts;
        $this->context['category'] = new TimberTerm($atts['category_id']);
        $this->context['articles'] = $this->getArticles($atts['category_id']);

        return Timber::fetch('page-builder/article-links.twig', $this->context);
    }
} // End Element Class

// Element Class Init
new ArticleLinksElement();
