<?php

namespace every1base\PageBuilder\Elements;

use Timber;
use \WPBakeryShortCode;

require_once __DIR__ . '/../../includes/colors.php';

// Element Class
class ButtonElement extends WPBakeryShortCode
{

    // Element Init
    public function __construct()
    {
        add_action('init', [ $this, 'mapping' ],12);
        add_shortcode('vc_every1_button', [ $this, 'html' ]);
    }

    // Element Mapping
    public function mapping()
    {

        // Stop all if VC is not enabled
        if (!defined('WPB_VC_VERSION')) {
            return;
        }

        // Map the block with vc_map()
        vc_map(
            [
                'name' => __('Button', 'text-domain'),
                'base' => 'vc_every1_button',
                'description' => __('Button that can act as link', 'text-domain'),
                'category' => __('Custom Elements', 'text-domain'),
                'icon' => get_template_directory_uri().'/dist/images/vc_icons/every1-vc-button.png',
                'params' => [
                    [
                        'type' => 'checkbox',
                        'heading' => __('Display as Link?', 'text-domain'),
                        'param_name' => 'button_aslink',
                        'weight' => 0,
                        'std' => false,
                    ],
                    [
                        'type' => 'dropdown',
                        'heading' => __('Button alignment', 'text-domain'),
                        'param_name' => 'align',
                        'value' => [
                            __('Left', 'text-domain') => 'left',
                            __('Centre', 'text-domain') => 'center',
                            __('Right', 'text-domain') => 'right',
                          ],
                        'std' => 'left',
                        'description' => __('Which direction to align the button', 'text-domain'),
                        'class' => '',
                        'admin_label' => true,
                    ],
                    [
                        'type' => 'dropdown',
                        'heading' => __('Background Colour', 'text-domain'),
                        'param_name' => 'bgcolor',
                        'value' => getColors(),
                        'std' => 'blue',
                        'description' => __('Select the colour of the button background, defaults to brown', 'text-domain'),
                        'class' => '',
                        'admin_label' => true,
                    ],
                    [
                        'type' => 'dropdown',
                        'heading' => __('Text Colour', 'text-domain'),
                        'param_name' => 'color',
                        'value' => getColors(),
                        'std' => 'white',
                        'description' => __('Select the colour to display the text in, defaults to white', 'text-domain'),
                        'class' => '',
                        'admin_label' => true,
                    ],
                    [
                        'type' => 'vc_link',
                        'heading' => __('Link', 'text-domain'),
                        'param_name' => 'button_link',
                        'admin_label' => false,
                        'weight' => 0,
                    ],
                    [
                        'type' => 'textfield',
                        'heading' => __('Button label', 'text-domain'),
                        'param_name' => 'label',
                        'admin_label' => false,
                        'weight' => 0,
                    ],
                ],
            ]
        );
    }

    public function html($atts, $content = null)
    {
        $this->context = Timber::get_context();
        $this->context['atts'] = $atts;
        $this->context['content'] = $content;
         if ( isset( $atts['button_link'] ) ) {
            $this->context['atts']['button_link'] = vc_build_link( $atts['button_link'] );
        }
        return Timber::fetch('page-builder/button.twig', $this->context);
    }
} // End Element Class


// Element Class Init
new ButtonElement();
