<?php

namespace every1base\PageBuilder\Elements;

use Timber;
use TimberImage;
use WPBakeryShortCode;

// Element Class
class ContentCarouselElement extends WPBakeryShortCode
{
    // Element Init
    public function __construct()
    {
        add_action('init', [$this, 'mapping'], 12);
        add_shortcode('vc_every1_content_carousel', [$this, 'html']);
        add_shortcode('vc_every1_content_carousel_child', [$this, 'html_child']);
    }

    // Element Mapping
    public function mapping()
    {
        // Stop all if VC is not enabled
        if (!defined('WPB_VC_VERSION')) {
            return;
        }

        // Map the block with vc_map()
        vc_map(
            [
                'name' => __('Content Slider', 'text-domain'),
                'base' => 'vc_every1_content_carousel',
                'category' => __('Custom Elements', 'text-domain'),
                'description' => __('Will display as a carousel on small screens, a 3 column grid on larger screens', 'text-domain'),
                'icon' => get_template_directory_uri().'/dist/images/vc_icons/every1-vc-slider.png',
                'as_parent' => ['only' => 'vc_every1_content_carousel_child'],
                'content_element' => true,
                'show_settings_on_create' => false,
                'is_container' => true,
                'js_view' => 'VcColumnView',
                'params' => [
                  [
                      'type' => 'textfield',
                      'heading' => __('Title', 'text-domain'),
                      'param_name' => 'title',
                      'weight' => 0,
                      'std' => false,
                  ], ],
            ]
        );

        vc_map(
            [
                'name' => __('Content slide', 'text-domain'),
                'base' => 'vc_every1_content_carousel_child',
                'description' => __('Content Slie', 'text-domain'),
                'category' => __('Custom Elements', 'text-domain'),
                'icon' => get_template_directory_uri().'/dist/images/vc_icons/every1-vc-slider.png',
                'as_child' => ['only' => 'vc_every1_content_carousel'],
                'content_element' => true,
                'show_settings_on_create' => true,
                'params' => [
                    [
                        'type' => 'textfield',
                        'heading' => __('Title', 'text-domain'),
                        'param_name' => 'title',
                        'std' => '',
                        'description' => __('Title', 'text-domain'),
                        'class' => '',
                        'admin_label' => true,
                    ],
                    [
                        'type' => 'textarea',
                        'heading' => __('Description', 'text-domain'),
                        'param_name' => 'description',
                        'std' => '',
                        'description' => __('Description - shown on hover', 'text-domain'),
                        'class' => '',
                        'admin_label' => true,
                    ],
                    [
                        'type' => 'attach_image',
                        'holder' => 'img',
                        'heading' => __('Image', 'text-domain'),
                        'param_name' => 'image',
                        'admin_label' => false,
                        'weight' => 0,
                    ],
                    [
                        'type' => 'vc_link',
                        'heading' => __('Link', 'inivos'),
                        'param_name' => 'page_link',
                        'admin_label' => false,
                        'weight' => 0,
                    ],
                ],
            ]
        );
    }

    public function html($atts, $content = null)
    {
        $this->context['atts'] = $atts;
        $this->context['content'] = $content;

        return Timber::fetch('page-builder/content-carousel.twig', $this->context);
    }

    public function html_child($atts, $content = null)
    {
        $this->context = Timber::get_context();
        $this->context['atts'] = $atts;
        $this->context['content'] = $content;
        $this->context['image'] = new TimberImage($atts['image']);
        if (isset($atts['page_link'])) {
            $this->context['atts']['page_link'] = vc_build_link($atts['page_link']);
        }

        return Timber::fetch('page-builder/child/content-carousel-child.twig', $this->context);
    }
} // End Element Class

// Element Class Init
new ContentCarouselElement();
