<?php

namespace every1base\PageBuilder\Elements;

use Timber;
use WPBakeryShortCode;

require_once __DIR__.'/../../includes/colors.php';

// Element Class
class CtaStripElement extends WPBakeryShortCode
{
    // Element Init
    public function __construct()
    {
        add_action('init', [$this, 'mapping'], 12);
        add_shortcode('vc_every1_cta_strip', [$this, 'html']);
    }

    // Element Mapping
    public function mapping()
    {
        // Stop all if VC is not enabled
        if (!defined('WPB_VC_VERSION')) {
            return;
        }

        // Map the block with vc_map()
        vc_map(
            [
                'name' => __('CTA Strip', 'text-domain'),
                'base' => 'vc_every1_cta_strip',
                'description' => __('A message to display at any part of a page', 'text-domain'),
                'category' => __('Custom Elements', 'text-domain'),
                'icon' => get_template_directory_uri().'/dist/images/vc_icons/every1-vc-button.png',
                'params' => [
                    [
                        'type' => 'textfield',
                        'heading' => __('Message', 'text-domain'),
                        'param_name' => 'message',
                        'weight' => 0,
                        'std' => false,
                    ],
                    [
                      'type' => 'textfield',
                      'heading' => __('Button label', 'text-domain'),
                      'param_name' => 'label',
                      'admin_label' => false,
                      'weight' => 0,
                    ],
                    [
                        'type' => 'vc_link',
                        'heading' => __('Link', 'text-domain'),
                        'param_name' => 'button_link',
                        'admin_label' => false,
                        'weight' => 0,
                    ],
                ],
            ]
        );
    }

    public function html($atts, $content = null)
    {
        $this->context = Timber::get_context();
        $this->context['atts'] = $atts;
        $this->context['content'] = $content;
        if (isset($atts['button_link'])) {
            $this->context['atts']['button_link'] = vc_build_link($atts['button_link']);
        }

        return Timber::fetch('page-builder/cta-strip.twig', $this->context);
    }
} // End Element Class

// Element Class Init
new CtaStripElement();
