<?php

namespace every1\PageBuilder\Elements;

use Timber;
use WPBakeryShortCode;

// Element Class
class FaqCustomListElement extends WPBakeryShortCode
{
    protected $context;

    // Element Init
    public function __construct()
    {
        add_action('init', [$this, 'mapping'], 12);
        add_shortcode('vc_every1_faq_custom_list', [$this, 'html']);
        add_shortcode('vc_every1_faq_custom_list_child', [$this, 'html_child']);
    }

    // Element Mapping
    public function mapping()
    {
        // Stop all if VC is not enabled
        if (!defined('WPB_VC_VERSION')) {
            return;
        }

        // Map the block with vc_map()
        vc_map(
            [
                'name' => __('FAQ Custom List', 'text-domain'),
                'base' => 'vc_every1_faq_custom_list',
                'description' => __('List of selectable FAQs with extra top content', 'text-domain'),
                'category' => __('Custom Elements', 'text-domain'),
                'icon' => get_template_directory_uri().'/dist/images/pb-icon--pioneer-trax.png',
                'as_parent' => ['only' => 'vc_every1_faq_custom_list_child'],
                'content_element' => true,
                'show_settings_on_create' => true,
                'is_container' => true,
                'js_view' => 'VcColumnView',
                'params' => [
                    [
                        'type' => 'textfield',
                        'heading' => __('Header Main title', 'text-domain'),
                        'param_name' => 'maintitle',
                        'std' => '',
                        'description' => __('The text to display for the main title', 'text-domain'),
                        'class' => '',
                        'admin_label' => true,
                    ],
                ],
            ]
        );

        vc_map(
            [
                'name' => __('FAQ Custom List Child', 'text-domain'),
                'base' => 'vc_every1_faq_custom_list_child',
                'description' => __('Selectable FAQ', 'text-domain'),
                'category' => __('Custom Elements', 'text-domain'),
                'content_element' => true,
                'icon' => get_template_directory_uri().'/dist/images/pb-icon--pioneer-trax.png',
                'as_child' => ['only' => 'vc_every1_faq_custom_list'],
                'show_settings_on_create' => true,
                'params' => [
                    [
                        'type' => 'dropdown',
                        'holder' => 'div',
                        'heading' => __('FAQ Selector', 'text-domain'),
                        'param_name' => 'faq_id',
                        'value' => $this->getSelectableFaqs(),
                        'description' => __('Select the FAQ', 'text-domain'),
                        'class' => '',
                    ],
                ],
            ]
        );
    }

    public function getSelectableFaqs()
    {
        // create array of faqs: faq_list[title] = id

        $faqlist = [];

        $faqs = Timber::get_posts([
                'order' => 'ASC',
                'orderby' => 'title',
                'post_type' => 'faq',
                'post_status' => 'publish',
                'posts_per_page' => -1,
            ]);

        // foreach($faqs as $faq){
        //     $faqlist[$faq->post_title." (".$faq->ID.")"] = $faq->post_title." (#".$faq->ID.")";
        // }
        foreach ($faqs as $faq) {
            $faqlist[] = [
                    'faq_id' => $faq->id,
                    'faq_name' => $faq->title,
                ];
            //$faqlist[$faq->post_title." (".$faq->ID.")"] = $faq->post_title." (#".$faq->ID.")";
        }

        return $faqlist;
    }

    public function getFaqs($faq_id)
    {
        return Timber::get_post($faq_id);
    }

    public function get_string_between($string, $start, $end)
    {
        $string = ' '.$string;
        $ini = strpos($string, $start);
        if ($ini == 0) {
            return '';
        }
        $ini += strlen($start);
        $len = strpos($string, $end, $ini) - $ini;

        return substr($string, $ini, $len);
    }

    public function html($atts, $content = null)
    {
        $this->context = Timber::get_context();
        $this->context['atts'] = $atts;
        $this->context['content'] = $content;

        return Timber::fetch('page-builder/faq-custom-list.twig', $this->context);
    }

    public function html_child($atts, $content = null)
    {
        $this->context = Timber::get_context();
        $this->context['atts'] = $atts;
        $this->context['content'] = $content;
        $this->context['faq'] = $this->getFaqs($atts['faq_id']);
        //$this->context['faq']['id'] = intval($this->get_string_between($atts['faq_id'],"(#",")"));
        // $this->context['faq']['question'] = get_field(('faq_question'),$this->context['faq']['id']);
        // $this->context['faq']['answer'] = get_field(('faq_answer'),$this->context['faq']['id']);

        return Timber::fetch('page-builder/child/faq-custom-list-child.twig', $this->context);

        // $this->context['atts'] = $atts;
        // $this->context['content'] = $content;

        // $this->context['faq']['id'] = intval($this->get_string_between($atts['faq_id'], '(#', ')'));
        // $this->context['faq']['question'] = get_field(('faq_question'), $this->context['faq']['id']);
        // $this->context['faq']['answer'] = get_field(('faq_answer'), $this->context['faq']['id']);

        // var_dump($this->context['faq']['id']);
        // return Timber::fetch('page-builder/child/faq-custom-list-child.twig', $this->context);
    }
} // End Element Class

// Element Class Init
new FaqCustomListElement();
