<?php

namespace PFPWPPROJECT\PageBuilder\Elements;

use Timber;
use WPBakeryShortCode;

// Element Class
class FaqSingleElement extends WPBakeryShortCode
{
    protected $context;

    // Element Init
    public function __construct()
    {

        add_action('init', [$this, 'mapping'], 12);
        add_shortcode('vc_phoenix_faq_single', [$this, 'html']);
    }

    public function faqlist()
    {
        // create array of faqs: faq_list[title] = id

        $faqs = new Timber\PostQuery([
            'order' => 'ASC',
            'orderby' => 'title',
            'post_type' => 'faq',
            'post_status' => 'publish',
            'posts_per_page' => -1,
        ], '\PFPWPPROJECT\TimberPost');

        $faqlist = array();
        foreach ($faqs as $faq) {
            $faqlist[$faq->post_title.' ('.$faq->ID.')'] = $faq->post_title.' (#'.$faq->ID.')';
        }

        return $faqlist;
    }

    /*
        public function getFaqCategories()
        {
    
           $faq_category = Timber::get_terms('faq_category');
           return $faq_category;
        }
    */

    // Element Mapping
    public function mapping()
    {
        // Stop all if VC is not enabled
        if (!defined('WPB_VC_VERSION')) {
            return;
        }

        // Map the block with vc_map()
        vc_map(
            [
                'name' => __('FAQ Single', 'text-domain'),
                'base' => 'vc_phoenix_faq_single',
                'description' => __('FAQ - select single faq', 'text-domain'),
                'category' => __('Custom Elements', 'text-domain'),
                'icon' => get_template_directory_uri().'/dist/images/pb-icon--trax.png',
                'params' => [
                    [
                        'type' => 'dropdown',
                        'holder' => 'div',
                        'heading' => __('FAQ Selector', 'text-domain'),
                        'param_name' => 'faq_id',
                        'value' => $this->faqlist(),
                        'description' => __('Select the FAQ', 'text-domain'),
                        'class' => '',
                    ],
                ],
            ]
        );
    }

    public function get_string_between($string, $start, $end)
    {
        $string = ' '.$string;
        $ini = strpos($string, $start);
        if ($ini == 0) {
            return '';
        }
        $ini += strlen($start);
        $len = strpos($string, $end, $ini) - $ini;

        return substr($string, $ini, $len);
    }

    public function html($atts, $content = null)
    {
        $this->context = Timber::get_context();
        $faq_id = intval($this->get_string_between($atts['faq_id'], '(#', ')'));

        $faq_cats = get_the_terms($faq_id, 'faq_category');
        $faq_primary_cat = $faq_cats[0];
        $this->context['faq']['category_slug'] = $faq_primary_cat->slug;
        $this->context['faq']['question'] = get_field(('faq_question'), $faq_id);
        $this->context['faq']['id'] = $faq_id;
        $this->context['faq']['answer'] = get_field(('faq_answer'), $faq_id);

        return Timber::fetch('page-builder/faq-single.twig', $this->context);
    }
} // End Element Class

// Element Class Init
new FaqSingleElement();
