<?php

namespace every1base\PageBuilder\Elements;

use Timber;
use \WPBakeryShortCode;
use TimberImage;

require_once __DIR__ . '/../../includes/colors.php';

// Element Class
class SpacerElement extends WPBakeryShortCode
{

    // Element Init
    public function __construct()
    {
        add_action('init', [ $this, 'mapping' ],12);
        add_shortcode('vc_every1_spacer', [ $this, 'html' ]);
    }

    // Element Mapping
    public function mapping()
    {

        // Stop all if VC is not enabled
        if (!defined('WPB_VC_VERSION')) {
            return;
        }

        // Map the block with vc_map()
        vc_map(
            [
                'name' => __('Spacer', 'text-domain'),
                'base' => 'vc_every1_spacer',
                'description' => __('Spacer with 4 responsive breakpoints', 'text-domain'),
                'category' => __('Custom Elements', 'text-domain'),
                'icon' => get_template_directory_uri().'/dist/images/vc_icons/every1-vc-spacer.png',
                'params' => [
                    [
                        'type' => 'textfield',
                        'heading' => __('Mobile Spacer', 'text-domain'),
                        'param_name' => 'm_spacer',
                        'admin_label' => false,
                        'weight' => 0,
                    ],
                    [
                        'type' => 'textfield',
                        'heading' => __('Tablet (Portrait) Spacer', 'text-domain'),
                        'param_name' => 'tp_spacer',
                        'admin_label' => false,
                        'weight' => 0,
                    ],
                    [
                        'type' => 'textfield',
                        'heading' => __('Tablet (landscape) Spacer', 'text-domain'),
                        'param_name' => 'tl_spacer',
                        'admin_label' => false,
                        'weight' => 0,
                    ],
                    [
                        'type' => 'textfield',
                        'heading' => __('Desktop Spacer', 'text-domain'),
                        'param_name' => 'd_spacer',
                        'admin_label' => false,
                        'weight' => 0,
                    ],
                ],
            ]
        );
    }


    public function html($atts, $content = null)
    {
        $this->context = Timber::get_context();
        $uid = uniqid();
        $this->context['uid'] = $uid;
        $this->context['atts'] = $atts;

        return Timber::fetch('page-builder/spacer.twig', $this->context);
    }
} // End Element Class


// Element Class Init
new SpacerElement();
