<?php

namespace every1base\PageBuilder\Elements;

use Timber;
use TimberImage;
use WPBakeryShortCode;

require_once __DIR__.'/../../includes/colors.php';

// Element Class
class VideoBannerElement extends WPBakeryShortCode
{
    // Element Init
    public function __construct()
    {
        add_action('init', [$this, 'mapping'], 12);
        add_shortcode('vc_every1_video-banner', [$this, 'html']);
    }

    // Element Mapping
    public function mapping()
    {
        // Stop all if VC is not enabled
        if (!defined('WPB_VC_VERSION')) {
            return;
        }

        // Map the block with vc_map()
        vc_map(
            [
                'name' => __('Video Banner', 'text-domain'),
                'base' => 'vc_every1_video-banner',
                'description' => __('A banner that can play a background video', 'text-domain'),
                'category' => __('Custom Elements', 'text-domain'),
                'icon' => get_template_directory_uri().'/dist/images/vc_icons/every1-vc-button.png',
                'params' => [
                    [
                        'type' => 'textfield',
                        'heading' => __('Section Title', 'text-domain'),
                        'param_name' => 'section_title',
                        'weight' => 0,
                        'std' => false,
                    ],
                    [
                        'type' => 'textarea_html',
                        'heading' => __('Section Content', 'text-domain'),
                        'param_name' => 'content',
                        'weight' => 0,
                        'std' => false,
                    ],
                    [
                        'type' => 'attach_image',
                        'heading' => __('Background image', 'text-domain'),
                        'param_name' => 'bgimage',
                        'std' => '',
                        'description' => __('A background image to display in case video playback is not supported', 'text-domain'),
                        'class' => '',
                        'admin_label' => true,
                    ],
                    [
                      'type' => 'file_picker',
                      'heading' => __('Background video', 'text-domain'),
                      'param_name' => 'video',
                      'std' => '',
                      'class' => '',
                      'admin_label' => true,
                  ],
                  [
                    'type' => 'textfield',
                    'heading' => __('Wistia Video ID', 'text-domain'),
                    'param_name' => 'video_id',
                    'std' => '',
                    'description' => __('Wistia video ID', 'text-domain'),
                    'class' => '',
                    'admin_label' => true,
                  ],
                  [
                    'type' => 'vc_link',
                    'heading' => __('Additional link', 'inivos'),
                    'param_name' => 'page_link',
                    'admin_label' => false,
                    'weight' => 0,
                ],
                  [
                    'type' => 'textfield',
                    'heading' => __('Additional link label', 'text-domain'),
                    'param_name' => 'link_label',
                    'std' => '',
                    'description' => __('Button label for additional link', 'text-domain'),
                    'class' => '',
                    'admin_label' => true,
                  ],
                ],
            ]
        );
    }

    public function html($atts, $content = null)
    {
        $this->context = Timber::get_context();
        $this->context['atts'] = $atts;
        $this->context['content'] = $content;
        $this->context['video'] = new TimberImage($atts['video']);
        $this->context['image'] = new TimberImage($atts['bgimage']);
        if (isset($atts['page_link'])) {
            $this->context['atts']['page_link'] = vc_build_link($atts['page_link']);
        }

        return Timber::fetch('page-builder/video-banner.twig', $this->context);
    }
} // End Element Class

// Element Class Init
new VideoBannerElement();
