<?php
/**
 * The Template for displaying all single posts
 *
 * Methods for TimberHelper can be found in the /lib sub-directory
 *
 * @package  every1base
 * @subpackage  Timber
 * @since    Timber 0.1
 */

$context = Timber::get_context();
$post = Timber::query_post();
$context['post'] = $post;

$blogId = get_the_id();
$categories = get_the_terms($blogId, 'category');
$context['categories'] = $categories;
$author_id = get_the_author_meta('ID');
$user_bio_intro = get_field('user_bio_intro', 'user_'. $author_id );

$context['userpic'] =   get_avatar( get_the_author_meta('ID'), 100 ); 
$context['bio_intro'] =  $user_bio_intro;


Timber::render([ 'single-' . $post->ID . '.twig', 'single-' . $post->post_type . '.twig', 'single.twig' ], $context);