jQuery(document).ready(function ($) {
  var didScroll;
  var lastScrollTop = 5;
  var delta = 40;
  var navbarHeight = $(".c-site-header").outerHeight();

  $(window).scroll(function (event) {
    didScroll = true;
  });

  setInterval(function () {
    if (didScroll) {
      hasScrolled();
      didScroll = false;
    }
  }, 50);

  function navUp() {
    $(".c-site-header")
      .removeClass("c-site-header__nav-down")
      .addClass("c-site-header__nav-up");
    $(".c-site-message")
      .removeClass("c-site-message__nav-down")
      .addClass("c-site-message__nav-up");
  }

  function navDown() {
    $(".c-site-header")
      .removeClass("c-site-header__nav-up")
      .addClass("c-site-header__nav-down");
    $(".c-site-message")
      .removeClass("c-site-message__nav-up")
      .addClass("c-site-message__nav-down");
  }

  function navTop() {
    $(".c-site-header")
      .removeClass("c-site-header__nav-up")
      .removeClass("c-site-header__nav-down");
    $(".c-site-message")
      .removeClass("c-site-message__nav-up")
      .removeClass("c-site-message__nav-down");
  }

  function hasScrolled() {
    var st = $(this).scrollTop();
    // Make sure they scroll more than delta
    if (Math.abs(lastScrollTop - st) <= delta) return;

    // If they scrolled down and are past the navbar, add class .nav-up.
    // This is necessary so you never see what is "behind" the navbar.
    if (st > lastScrollTop && st > navbarHeight) {
      // Scroll Down
      navUp();
    } else {
      // Scroll Up
      if (st + $(window).height() < $(document).height()) {
        navDown();
      }
    }
    //console.log(st);

    if (st <= 240) {
      navTop();
    }

    lastScrollTop = st;
  }
});