<?php 

namespace sixon;

class Sixon {

    private $pluginName;

    function __construct() {

        // Set the plugin name (same as folder name)
        $this->pluginName = "sixon-hosting";

        // Get the API Key from the CMS
        // $this->api_key = $this->get_api_key();

        // Register the scripts & styles
        // if (is_admin()):
            // add_filter('admin_enqueue_scripts', array( $this, 'enqueue_scripts_styles_backend'));
        // else: 
            // add_filter('wp_enqueue_scripts', array( $this, 'enqueue_scripts_styles_frontend'));
        // endif;

        // $this->init();

        // define( 'WPE_WHITELABEL', 'true' );

        add_action( 'admin_menu', array($this, 'createSidebarMenu'));

        add_action( 'admin_init', array($this, 'removeWPEngineBranding'));
        add_action( 'admin_bar_menu', array($this, 'removeWPEngineAdminBar'), 90);
        add_action( 'wp_dashboard_setup', array($this, 'removeWPEngineAdminWidget'), );
    }



    /**
     * SELF CLASS INSTANTIATION
     * This allows WordPress to instantiate this class on load.
     * 
     * @return class
     */
    public static function instance() 
    {
        $class = __CLASS__;
        return (new $class);
    }


    // public function init() 
    // {

    //     $this->removeWPEngineMenu();

    // }


    public function createSidebarMenu() 
    {
        add_menu_page(
            "SIXON Hosting",
            'SIXON Hosting',
            'manage_options',
            sanitize_key('sixon'),
            array($this, 'page_admin_sixon_main'),
            'dashicons-admin-multisite',
            0
        );
    }


    public function page_admin_sixon_main() 
    {
        ?>
            <h1>
                <?php esc_html_e( 'Welcome to SIXON', $this->pluginName ); ?>
            </h1>
        <?php
    }

    public function removeWPEngineBranding()
    {   

        $hide = true;
        global $user_ID;
        $user = get_user_by('ID', $user_ID);
        
        if (str_contains($user->user_email, 'sixon')) 
            $hide = false;
        
        if ( $hide ) {
            remove_menu_page('wpengine-common');
        }

    }

    public function removeWPEngineAdminBar($wp_admin_bar)
    {   

        $hide = true;
        global $user_ID;
        $user = get_user_by('ID', $user_ID);

        if (str_contains($user->user_email, 'sixon')) 
            $hide = false;

        if ( $hide ) {
            $wp_admin_bar->remove_node( 'wpengine_adminbar' );
            $wp_admin_bar->remove_menu( 'wpengine_adminbar' );
        }

    }


    public function removeWPEngineAdminWidget()
    {   
        global $wp_meta_boxes;

        $hide = true;
        global $user_ID;
        $user = get_user_by('ID', $user_ID);

        if (str_contains($user->user_email, 'sixon')) 
            $hide = false;

        if ( $hide ) {
            unset($wp_meta_boxes['dashboard']['normal']['high']['llar_stats_widget']);
            remove_meta_box( 'wpe_dify_news_feed','dashboard','side' );
        }

    }


    /**
     * LOAD FRONTEND SCRIPTS & STYLES
     * This function allows the loading on custom frontend scripts. 
     */
    // function enqueue_scripts_styles_frontend() {

    //     if (file_exists(WP_PLUGIN_DIR . '/' . $this->pluginName . '/.develop')):
    //         wp_enqueue_style ("laniakea-" . $this->pluginName, plugins_url() . '/' . $this->pluginName . '/dist/css/frontend.css');
    //         wp_enqueue_script("laniakea-" . $this->pluginName, plugins_url() . '/' . $this->pluginName . '/src/js/frontend.js', [], 0, true);
    //     else: 
    //         wp_enqueue_style ("laniakea-" . $this->pluginName, plugins_url() . '/' . $this->pluginName . '/dist/css/frontend.min.css');
    //         wp_enqueue_script("laniakea-" . $this->pluginName, plugins_url() . '/' . $this->pluginName . '/dist/js/frontend.min.js', [], 0, true);
    //     endif;
    // }



    /**
     * LOAD BACKEND SCRIPTS & STYLES
     * This function allows the loading on custom backend or CMS scripts. 
     */
    // function enqueue_scripts_styles_backend() {

    //     if (file_exists(WP_PLUGIN_DIR . '/' . $this->pluginName . '/.develop')):
    //         wp_enqueue_style ("laniakea-" . $this->pluginName, plugins_url() . '/' . $this->pluginName . '/dist/css/backend.css');
    //         wp_enqueue_script("laniakea-" . $this->pluginName, plugins_url() . '/' . $this->pluginName . '/src/js/backend.js', [], 0, true);
    //     else: 
    //         wp_enqueue_style ("laniakea-" . $this->pluginName, plugins_url() . '/' . $this->pluginName . '/dist/css/backend.min.css');
    //         wp_enqueue_script("laniakea-" . $this->pluginName, plugins_url() . '/' . $this->pluginName . '/dist/js/backend.min.js', [], 0, true);
    //     endif;
    // }
}