<?php
/**
 * The template for displaying 404 pages (not found).
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package template
 */

get_header(); ?>

<div class="container">
	<div class="row">

		<section class="error-404 not-found">
			<header class="page-header">
				<h1><?php esc_html_e( 'Oops! That page can&rsquo;t be found.', 'cips_training' ); ?></h1>
			</header>
			<div class="content">
				<p><?php esc_html_e( 'It looks like nothing was found at this location. Maybe try one of the links below.', 'cips_training' ); ?></p>
				<p><?php esc_html_e( 'Your request has been logged and we\'ll fix it up shortly.', 'cips_training' ); ?></p>
				<a href="/" class="btn btn-primary">Take me Home!</a>
			</div>
		</section>

	</div>
</div>

<?php
get_footer();
